/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.ServerCommHelper;
import org.ametys.plugins.core.ui.user.DefaultProfileImageProvider;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetUserProfileImagesAction
extends ServiceableAction {
    protected ServerCommHelper _serverCommHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected DefaultProfileImageProvider _profileImageProvider;

    public void service(ServiceManager sm) throws ServiceException {
        super.service(sm);
        this._serverCommHelper = (ServerCommHelper)sm.lookup(ServerCommHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)sm.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        if (this._profileImageProvider == null) {
            try {
                this._profileImageProvider = (DefaultProfileImageProvider)this.manager.lookup(ProfileImageProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Lazy initialization failed.", e);
            }
        }
        Map<String, Object> jsParameters = this._serverCommHelper.getJsParameters();
        String login = (String)jsParameters.get("login");
        String populationId = (String)jsParameters.get("populationId");
        UserIdentity user = StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)populationId) ? this._currentUserProvider.getUser() : new UserIdentity(login, populationId);
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        ArrayList<Map<String, Object>> images = new ArrayList<Map<String, Object>>();
        result.put("images", images);
        this._addStoredImage(images, user);
        this._addGravatarImage(images, user);
        this._addInitialsImage(images, user);
        this._addLocalImages(images, login);
        this._addDefaultImage(images);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected void _addStoredImage(List<Map<String, Object>> images, UserIdentity user) {
        Map<String, Object> rawUserPrefImage = this._profileImageProvider.hasUserPrefImage(user);
        String base64Source = DefaultProfileImageProvider.ProfileImageSource.BASE64.name().toLowerCase();
        if (rawUserPrefImage != null && base64Source.equals(rawUserPrefImage.get("source"))) {
            HashMap<String, String> image = new HashMap<String, String>();
            image.put("source", DefaultProfileImageProvider.ProfileImageSource.USERPREF.name().toLowerCase());
            images.add(image);
        }
    }

    protected void _addGravatarImage(List<Map<String, Object>> images, UserIdentity user) {
        String gravatarSource = DefaultProfileImageProvider.ProfileImageSource.GRAVATAR.name().toLowerCase();
        if (this._profileImageProvider.hasGravatarImage(user)) {
            HashMap<String, String> image = new HashMap<String, String>();
            image.put("source", gravatarSource);
            images.add(image);
        }
    }

    protected void _addInitialsImage(List<Map<String, Object>> images, UserIdentity user) {
        String initialsSource = DefaultProfileImageProvider.ProfileImageSource.INITIALS.name().toLowerCase();
        if (this._profileImageProvider.hasInitialsImage(user)) {
            HashMap<String, String> image = new HashMap<String, String>();
            image.put("source", initialsSource);
            images.add(image);
        }
    }

    protected void _addLocalImages(List<Map<String, Object>> images, String login) {
        List<String> localImageIds = this._profileImageProvider.getLocalImageIds();
        String localImageSource = DefaultProfileImageProvider.ProfileImageSource.LOCALIMAGE.name().toLowerCase();
        for (String id : localImageIds) {
            if (!this._profileImageProvider.hasLocalImage(id)) continue;
            HashMap<String, Object> image = new HashMap<String, Object>();
            image.put("source", localImageSource);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("id", id);
            image.put("parameters", parameters);
            images.add(image);
        }
    }

    protected void _addDefaultImage(List<Map<String, Object>> images) {
        String defaultSource = DefaultProfileImageProvider.ProfileImageSource.DEFAULT.name().toLowerCase();
        HashMap<String, String> image = new HashMap<String, String>();
        image.put("source", defaultSource);
        images.add(image);
    }
}

