/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.ImageHelper;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ProfileImageReader
extends ServiceableReader {
    public static final Collection<String> ALLOWED_IMG_FORMATS = Arrays.asList("png", "gif", "jpg", "jpeg");
    protected CurrentUserProvider _currentUserProvider;
    private ProfileImageProvider _profileImageProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    private ProfileImageProvider getProfileImageProvider() {
        if (this._profileImageProvider == null) {
            try {
                this._profileImageProvider = (ProfileImageProvider)this.manager.lookup(ProfileImageProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Lazy initialization failed.", e);
            }
        }
        return this._profileImageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, ProcessingException {
        String imageSourceStr = StringUtils.defaultString((String)this.parameters.getParameter("image-source", null));
        UserIdentity user = this._getUser();
        boolean download = this.parameters.getParameterAsBoolean("download", false);
        int size = this.parameters.getParameterAsInteger("size", 0);
        int maxSize = this.parameters.getParameterAsInteger("maxSize", 0);
        ProfileImageProvider.UserProfileImage image = this.getProfileImageProvider().getImage(user, imageSourceStr, size, maxSize);
        try {
            Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
            this._readImage(response, user, image, download, size, maxSize);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }

    private UserIdentity _getUser() {
        String login = this.parameters.getParameter("login", "");
        String populationId = this.parameters.getParameter("populationId", "");
        if (StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)populationId)) {
            return this._currentUserProvider.getUser();
        }
        return new UserIdentity(login, populationId);
    }

    protected void _readImage(Response response, UserIdentity user, ProfileImageProvider.UserProfileImage image, boolean download, int size, int maxSize) throws IOException {
        try (InputStream is = image.getInputstream();){
            String filename = (String)StringUtils.defaultIfEmpty((CharSequence)image.getFilename(), (CharSequence)(user.getLogin() + ".png"));
            String format = FilenameUtils.getExtension((String)filename);
            String string = format = ALLOWED_IMG_FORMATS.contains(format) ? format : "png";
            if (download) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            }
            if (size > 0 || maxSize > 0) {
                ImageHelper.generateThumbnail(is, this.out, format, size, size, maxSize, maxSize);
            } else {
                Long length = image.getLength();
                if (length != null && length > 0L) {
                    response.setHeader("Content-Length", Long.toString(length));
                }
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
            }
        }
    }
}

