/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesErrors;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.user.DefaultProfileImageProvider;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.ametys.plugins.core.ui.user.ProfileImageReader;
import org.ametys.plugins.core.userpref.SetUserPreferencesAction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class SetUserProfileAction
extends SetUserPreferencesAction {
    protected JSONUtils _jsonUtils;
    protected DefaultProfileImageProvider _profileImageProvider;
    protected UploadManager _uploadManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    @Override
    protected Map<String, String> _getValues(Request request, Map<String, String> contextVars, UserIdentity user, Collection<String> preferenceIds, UserPreferencesErrors errors) {
        Map<String, String> preferences;
        String userPrefImageJson;
        if (this._profileImageProvider == null) {
            try {
                this._uploadManager = (UploadManager)this.manager.lookup(UploadManager.ROLE);
                this._profileImageProvider = (DefaultProfileImageProvider)this.manager.lookup(ProfileImageProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Lazy initialization failed.", e);
            }
        }
        if (StringUtils.isNotEmpty((String)(userPrefImageJson = (preferences = super._getValues(request, contextVars, user, preferenceIds, errors)).get("profile-image")))) {
            Map<String, Object> userPrefImage = null;
            try {
                userPrefImage = this._jsonUtils.convertJsonToMap(userPrefImageJson);
            }
            catch (Exception e) {
                this.getLogger().error(String.format("Unable to extract image user pref for user '%s'.", user), (Throwable)e);
            }
            if (userPrefImage != null) {
                DefaultProfileImageProvider.ProfileImageSource profileImageSource = this._profileImageProvider.getProfileImageSource((String)userPrefImage.get("source"));
                if (DefaultProfileImageProvider.ProfileImageSource.USERPREF.equals((Object)profileImageSource)) {
                    preferences.remove("profile-image");
                } else if (DefaultProfileImageProvider.ProfileImageSource.UPLOAD.equals((Object)profileImageSource)) {
                    Map sourceParams = (Map)userPrefImage.get("parameters");
                    String uploadId = sourceParams != null ? (String)sourceParams.get("id") : null;
                    HashMap<String, String> base64SourceParams = null;
                    if (StringUtils.isNotEmpty((String)uploadId)) {
                        Upload upload = null;
                        try {
                            upload = this._uploadManager.getUpload(user, uploadId);
                            base64SourceParams = new HashMap<String, String>();
                            try (InputStream is = upload.getInputStream();){
                                String filename = upload.getFilename();
                                base64SourceParams.put("data", this._convertFile(filename, is));
                                base64SourceParams.put("filename", filename);
                            }
                            catch (IOException e) {
                                base64SourceParams = null;
                                this.getLogger().error(String.format("Unable to store the profile image user pref for user '%s'. Error while trying to convert the uploaded file '%s' to base64.", user, uploadId), (Throwable)e);
                            }
                        }
                        catch (NoSuchElementException e) {
                            this.getLogger().error(String.format("Cannot find the temporary uploaded file for id '%s' and login '%s'.", uploadId, user), (Throwable)e);
                        }
                    }
                    if (base64SourceParams != null) {
                        HashMap<String, Object> base64UserPrefImage = new HashMap<String, Object>();
                        base64UserPrefImage.put("source", DefaultProfileImageProvider.ProfileImageSource.BASE64.name().toLowerCase());
                        base64UserPrefImage.put("parameters", base64SourceParams);
                        preferences.put("profile-image", this._jsonUtils.convertObjectToJson(base64UserPrefImage));
                    } else {
                        preferences.remove("profile-image");
                    }
                }
            }
        }
        return preferences;
    }

    protected String _convertFile(String filename, InputStream is) throws IOException {
        BufferedImage image = this._profileImageProvider.cropUploadedImage(is);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String format = FilenameUtils.getExtension((String)filename);
            format = ProfileImageReader.ALLOWED_IMG_FORMATS.contains(format) ? format : "png";
            ImageIO.write((RenderedImage)image, format, baos);
            String string = Base64.encodeBase64URLSafeString((byte[])baos.toByteArray());
            return string;
        }
    }
}

