/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.user.InvalidModificationException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.user.UserDAO;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.Errors;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportUsers
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ImportUsers.class.getName();
    private static final String[] _ALLOWED_EXTENSIONS = new String[]{"txt", "csv"};
    private static final String[] _COLUMNS = new String[]{"login", "password", "firstname", "lastname", "email", "salt"};
    private static final String _COLUMN_LOGIN = "login";
    private static final String _COLUMN_PASSWORD = "password";
    private static final String _COLUMN_FIRSTNAME = "firstname";
    private static final String _COLUMN_LASTNAME = "lastname";
    private static final String _COLUMN_EMAIL = "email";
    private static final String _COLUMN_SALT = "salt";
    protected UserDAO _usersDao;
    protected UserManager _userManager;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        this._usersDao = (UserDAO)((Object)smanager.lookup(UserDAO.ROLE));
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._i18nUtils = (I18nUtils)((Object)smanager.lookup(I18nUtils.ROLE));
    }

    public Map<String, Object> importUsers(Part filePart, String populationId, String userDirectoryId, boolean cleanDirectory, boolean hashedPasswords) throws FileNotFoundException, InvalidModificationException {
        String filename;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (filePart instanceof RejectedPart) {
            result.put("success", false);
            result.put("error", "rejected-file");
            result.put("message", new I18nizableText("plugin.core", "PLUGINS_CORE_USERS_IMPORT_ERROR_REJECTED_FILE"));
            return result;
        }
        PartOnDisk uploadedFilePart = (PartOnDisk)filePart;
        File uploadedFile = uploadedFilePart != null ? uploadedFilePart.getFile() : null;
        String string = filename = uploadedFilePart != null ? uploadedFilePart.getFileName().toLowerCase() : null;
        if (!FilenameUtils.isExtension((String)filename, (String[])_ALLOWED_EXTENSIONS)) {
            result.put("success", false);
            result.put("error", "invalid-extension");
            result.put("message", new I18nizableText("plugin.core", "PLUGINS_CORE_USERS_IMPORT_ERROR_INVALID_EXTENSION"));
            return result;
        }
        try (FileInputStream fileIS = new FileInputStream(uploadedFile);
             BOMInputStream bomIS = new BOMInputStream((InputStream)fileIS);){
            List<Object> removedUsers;
            Map<String, List<UserIdentity>> parsedUsers = this.parseFile(bomIS, populationId, userDirectoryId, hashedPasswords);
            List<UserIdentity> addedUsers = parsedUsers.get("added");
            List<UserIdentity> editedUsers = parsedUsers.get("edited");
            if (cleanDirectory) {
                List usersToSave = ListUtils.union(addedUsers, editedUsers);
                removedUsers = this.clearUserDirectory(populationId, userDirectoryId, usersToSave);
            } else {
                removedUsers = new ArrayList();
            }
            result.put("success", true);
            result.put("addedCount", addedUsers.size());
            result.put("existingCount", editedUsers.size());
            result.put("errorCount", parsedUsers.get("error").size());
            result.put("deletedCount", removedUsers.size());
        }
        catch (IOException ioe) {
            result.put("success", false);
            result.put("error", IOException.class.getName());
            result.put("message", ioe.getLocalizedMessage());
        }
        catch (ImportUserActionException iuae) {
            result.put("success", false);
            result.put("error", iuae.getErrorName());
            result.put("message", iuae.getI18nizableText());
        }
        return result;
    }

    protected List<Map<String, String>> clearUserDirectory(String populationId, String userDirectoryId, List<UserIdentity> usersToSave) throws InvalidModificationException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Collection<User> existingUsersInDirectory = this._userManager.getUsersByDirectory(populationId, userDirectoryId, Integer.MAX_VALUE, 0, parameters);
        ArrayList<Map<String, String>> usersToDelete = new ArrayList<Map<String, String>>();
        UserIdentity currentUser = this._usersDao._getCurrentUser();
        for (User user : existingUsersInDirectory) {
            UserIdentity ui = user.getIdentity();
            if (usersToSave.contains(ui) || currentUser != null && currentUser.equals(ui)) continue;
            HashMap<String, String> userTodelete = new HashMap<String, String>();
            userTodelete.put(_COLUMN_LOGIN, ui.getLogin());
            userTodelete.put("populationId", ui.getPopulationId());
            usersToDelete.add(userTodelete);
        }
        this._usersDao.deleteUsers(usersToDelete);
        return usersToDelete;
    }

    protected Map<String, List<UserIdentity>> parseFile(BOMInputStream bomIS, String populationId, String userDirectoryId, boolean hashedPassword) throws IOException, ImportUserActionException {
        HashMap<String, Integer> order = new HashMap<String, Integer>();
        ArrayList<UserIdentity> addedUsers = new ArrayList<UserIdentity>();
        ArrayList<UserIdentity> editedUsers = new ArrayList<UserIdentity>();
        ArrayList<UserIdentity> errors = new ArrayList<UserIdentity>();
        boolean headerRead = false;
        for (String line : IOUtils.readLines((InputStream)bomIS, (Charset)StandardCharsets.UTF_8)) {
            String[] columns = (String[])Arrays.stream(line.split(";")).map(StringUtils::normalizeSpace).toArray(String[]::new);
            if (!headerRead) {
                this._checkCsvHeader(columns, hashedPassword);
                for (int i = 0; i < columns.length; ++i) {
                    String string = columns[i];
                    order.put(string, i);
                }
                headerRead = true;
                continue;
            }
            HashMap<String, String> untypedValues = new HashMap<String, String>();
            String login = columns[(Integer)order.get(_COLUMN_LOGIN)];
            UserIdentity userIdentity = new UserIdentity(login, populationId);
            untypedValues.put(_COLUMN_LOGIN, login);
            untypedValues.put(_COLUMN_PASSWORD, columns[(Integer)order.get(_COLUMN_PASSWORD)]);
            untypedValues.put(_COLUMN_FIRSTNAME, columns[(Integer)order.get(_COLUMN_FIRSTNAME)]);
            untypedValues.put(_COLUMN_LASTNAME, columns[(Integer)order.get(_COLUMN_LASTNAME)]);
            untypedValues.put(_COLUMN_EMAIL, columns[(Integer)order.get(_COLUMN_EMAIL)]);
            if (hashedPassword) {
                untypedValues.put(_COLUMN_SALT, columns[(Integer)order.get(_COLUMN_SALT)]);
                untypedValues.put("clearText", "false");
            } else {
                untypedValues.put("clearText", "true");
            }
            try {
                Map fieldErrors;
                User user = this._userManager.getUser(populationId, login);
                if (user == null) {
                    Map<String, Object> addedUser = this._usersDao.addUser(populationId, userDirectoryId, untypedValues);
                    if (addedUser.containsKey("errors")) {
                        fieldErrors = (Map)addedUser.get("errors");
                        errors.add(userIdentity);
                        this.getLogger().error("Failed to import user from inputs [{}] for population '{}' and user directory '{}' with the following error(s):\n{}", new Object[]{line, populationId, userDirectoryId, this._parseErrors(fieldErrors)});
                        continue;
                    }
                    addedUsers.add(userIdentity);
                    continue;
                }
                Map<String, Object> editedUser = this._usersDao.editUser(populationId, untypedValues);
                if (editedUser.containsKey("errors")) {
                    fieldErrors = (Map)editedUser.get("errors");
                    errors.add(userIdentity);
                    this.getLogger().error("Failed to edit user from inputs [{}] for population '{}' and user directory '{}' with the following error(s):\n{}", new Object[]{line, populationId, userDirectoryId, this._parseErrors(fieldErrors)});
                    continue;
                }
                editedUsers.add(userIdentity);
            }
            catch (InvalidModificationException e) {
                errors.add(userIdentity);
                this.getLogger().error("Unable to import user from inputs [{}] for population '{}' and user directory '{}'", new Object[]{line, populationId, userDirectoryId, e});
            }
        }
        HashMap<String, List<UserIdentity>> result = new HashMap<String, List<UserIdentity>>();
        result.put("added", addedUsers);
        result.put("edited", editedUsers);
        result.put("error", errors);
        return result;
    }

    private String _parseErrors(Map<String, Errors> errors) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Errors> entry : errors.entrySet()) {
            sb.append("[" + entry.getKey() + "] ");
            List<I18nizableText> errorLabels = entry.getValue().getErrors();
            for (I18nizableText errorLabel : errorLabels) {
                sb.append(this._i18nUtils.translate(errorLabel, Locale.ENGLISH.getLanguage())).append("; ");
            }
        }
        return sb.toString();
    }

    private void _checkCsvHeader(String[] columns, boolean hashedPassword) throws ImportUserActionException {
        for (String expectedColumn : _COLUMNS) {
            if (!hashedPassword && expectedColumn.equals(_COLUMN_SALT) && ArrayUtils.contains((Object[])columns, (Object)expectedColumn)) {
                throw new ImportUserActionException("PLUGINS_CORE_USERS_IMPORT_ERROR_COLUMN_SALT_PRESENT", "column-salt");
            }
            if (!(ArrayUtils.contains((Object[])columns, (Object)expectedColumn) || !hashedPassword && expectedColumn.equals(_COLUMN_SALT))) {
                ArrayList<String> params = new ArrayList<String>(1);
                params.add(expectedColumn);
                throw new ImportUserActionException("PLUGINS_CORE_USERS_IMPORT_ERROR_COLUMN_MISSING", "column-missing", params);
            }
            if (!ArrayUtils.contains((Object[])columns, (Object)expectedColumn) || ArrayUtils.indexOf((Object[])columns, (Object)expectedColumn) == ArrayUtils.lastIndexOf((Object[])columns, (Object)expectedColumn)) continue;
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(expectedColumn);
            throw new ImportUserActionException("PLUGINS_CORE_USERS_IMPORT_ERROR_COLUMN_DUPLICATE", "column-duplicate", params);
        }
    }

    private static class ImportUserActionException
    extends Exception {
        private I18nizableText _i18nizableText;
        private String _errorName;

        public ImportUserActionException(String i18nkey, String errorName, List<String> params) {
            this._i18nizableText = new I18nizableText("plugin.core", i18nkey, params);
            this._errorName = errorName;
        }

        public ImportUserActionException(String i18nkey, String errorName) {
            this._i18nizableText = new I18nizableText("plugin.core", i18nkey);
            this._errorName = errorName;
        }

        public I18nizableText getI18nizableText() {
            return this._i18nizableText;
        }

        public String getErrorName() {
            return this._errorName;
        }
    }
}

