/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.InvalidModificationException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.Errors;
import org.ametys.runtime.parameter.Parameter;
import org.ametys.runtime.parameter.ParameterHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class UserDAO
extends AbstractLogEnabled
implements Component,
Contextualizable,
Serviceable {
    public static final String ROLE = UserDAO.class.getName();
    protected ServiceManager _smanager;
    protected UserManager _userManager;
    protected UserPopulationDAO _userPopulationDAO;
    protected CurrentUserProvider _currentUserProvider;
    protected Context _context;
    protected UserHelper _userHelper;
    protected RightManager _rightManager;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    @Callable
    public Map<String, Object> getUser(String login, String populationId) {
        return this._userHelper.user2json(this._userManager.getUser(populationId, login), true);
    }

    @Callable
    public Map<String, Object> isModifiable(String login, String populationId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isModifiable", this._userManager.getUserDirectory(populationId, login) instanceof ModifiableUserDirectory);
        result.put("additionalDescription", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_USERS_EDIT_NO_MODIFIABLE_DESCRIPTION"));
        return result;
    }

    @Callable
    public Map<String, Object> isRemovable(String login, String populationId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        if (userDirectory != null && populationId.equals("admin_population") && userDirectory.getUsers().size() == 1) {
            result.put("isRemovable", false);
            result.put("additionalDescription", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_USERS_DELETE_LAST_ADMIN_DESCRIPTION"));
        } else {
            result.put("isRemovable", userDirectory instanceof ModifiableUserDirectory);
            result.put("additionalDescription", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_USERS_DELETE_NO_MODIFIABLE_DESCRIPTION"));
        }
        return result;
    }

    @Callable(right="Runtime_Rights_User_Handle")
    public Map<String, Object> addUser(String populationId, String userDirectoryId, Map<String, String> untypedValues) throws InvalidModificationException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(populationId);
        UserDirectory userDirectory = userPopulation.getUserDirectory(userDirectoryId);
        if (!(userDirectory instanceof ModifiableUserDirectory)) {
            this.getLogger().error("Users are not modifiable !");
            throw new InvalidModificationException("Users are not modifiable !");
        }
        ModifiableUserDirectory modifiableUserDirectory = (ModifiableUserDirectory)userDirectory;
        String login = untypedValues.get("login");
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(String.format("User %s is adding a new user '%s'", this._getCurrentUser(), login));
            }
            modifiableUserDirectory.add(untypedValues);
            return this._userHelper.user2json(modifiableUserDirectory.getUser(login), true);
        }
        catch (InvalidModificationException e) {
            Map<String, Errors> fieldErrors = e.getFieldErrors();
            if (fieldErrors == null || fieldErrors.size() <= 0) {
                throw e;
            }
            result.put("errors", fieldErrors);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Ending user's edition");
            }
            return result;
        }
    }

    @Callable(right="Runtime_Rights_User_Handle")
    public Map<String, Object> editUser(String populationId, Map<String, String> untypedValues) throws InvalidModificationException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String login = untypedValues.get("login");
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        if (!(userDirectory instanceof ModifiableUserDirectory)) {
            this.getLogger().error("Users are not modifiable !");
            throw new InvalidModificationException("Users are not modifiable !");
        }
        ModifiableUserDirectory modifiableUserDirectory = (ModifiableUserDirectory)userDirectory;
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(String.format("User %s is updating information about user '%s'", this._getCurrentUser(), login));
            }
            modifiableUserDirectory.update(untypedValues);
            return this._userHelper.user2json(modifiableUserDirectory.getUser(login), true);
        }
        catch (InvalidModificationException e) {
            Map<String, Errors> fieldErrors = e.getFieldErrors();
            if (fieldErrors == null || fieldErrors.size() <= 0) {
                throw e;
            }
            result.put("errors", fieldErrors);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Ending user's edition");
            }
            return result;
        }
    }

    @Callable(right="Runtime_Rights_User_Handle")
    public void deleteUsers(List<Map<String, String>> users) throws InvalidModificationException {
        for (Map<String, String> user : users) {
            String login = user.get("login");
            String populationId = user.get("populationId");
            this._deleteUser(login, populationId);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending user's removal");
        }
    }

    private void _deleteUser(String login, String populationId) throws InvalidModificationException {
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        if (!(userDirectory instanceof ModifiableUserDirectory)) {
            this.getLogger().error("Users are not modifiable !");
            throw new InvalidModificationException("Users are not modifiable !");
        }
        if (populationId.equals("admin_population") && userDirectory.getUsers().size() == 1) {
            this.getLogger().error("Deletion forbidden: last user of the 'admin' population.");
            throw new InvalidModificationException("You cannot delete the last user of the 'admin' population !");
        }
        ModifiableUserDirectory modifiableUserDirectory = (ModifiableUserDirectory)userDirectory;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is removing user '%s'", this._getCurrentUser(), login));
        }
        modifiableUserDirectory.remove(login);
    }

    @Callable(right="Runtime_Rights_User_Handle")
    public Map<String, Object> getEditionModelForUSer(String login, String populationId) throws InvalidModificationException, ProcessingException {
        UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
        return this._getEditionModel(userDirectory);
    }

    @Callable(right="Runtime_Rights_User_Handle")
    public Map<String, Object> getEditionModelForDirectory(String populationId, String userDirectoryId) throws InvalidModificationException, ProcessingException {
        UserDirectory userDirectory = this._userPopulationDAO.getUserPopulation(populationId).getUserDirectory(userDirectoryId);
        return this._getEditionModel(userDirectory);
    }

    private Map<String, Object> _getEditionModel(UserDirectory userDirectory) throws InvalidModificationException, ProcessingException {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        if (!(userDirectory instanceof ModifiableUserDirectory)) {
            this.getLogger().error("Users are not modifiable !");
            throw new InvalidModificationException("Users are not modifiable !");
        }
        ModifiableUserDirectory modifiableUserDirectory = (ModifiableUserDirectory)userDirectory;
        Collection<? extends Parameter<ParameterHelper.ParameterType>> parameters = modifiableUserDirectory.getModel();
        for (Parameter<ParameterHelper.ParameterType> parameter : parameters) {
            Map<String, Object> param2json = ParameterHelper.toJSON(parameter);
            param2json.put("type", ParameterHelper.typeToString(parameter.getType()));
            model.put(parameter.getId(), param2json);
        }
        return model;
    }

    @Callable(right="Runtime_Rights_User_Handle", context="/admin")
    public Map<String, String> impersonate(String login, String populationId) throws AccessDeniedException {
        UserIdentity currentUser = this._getCurrentUser();
        if (StringUtils.isEmpty((CharSequence)login)) {
            throw new IllegalArgumentException("'login' parameter is null or empty");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        User user = this._userManager.getUser(populationId, login);
        if (user == null) {
            result.put("error", "unknown-user");
        } else {
            try {
                this._currentUserProvider.logout();
            }
            catch (ProcessingException e) {
                this.getLogger().error("An error occurred while logging out current user " + currentUser);
            }
            Request request = ContextHelper.getRequest((Context)this._context);
            AuthenticateAction.setUserIdentityInSession(request, user.getIdentity(), new ImpersonateCredentialProvider(), true);
            result.put("login", login);
            result.put("populationId", populationId);
            result.put("name", user.getFullName());
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Impersonation of the user '" + login + "' from IP " + request.getRemoteAddr() + " done by " + currentUser);
            }
        }
        return result;
    }

    protected UserIdentity _getCurrentUser() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._smanager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalStateException(e);
            }
        }
        return this._currentUserProvider.getUser();
    }

    public static class ImpersonateCredentialProvider
    extends AbstractCredentialProvider
    implements BlockingCredentialProvider {
        @Override
        public boolean blockingGrantAnonymousRequest() {
            return false;
        }

        @Override
        public boolean blockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
            return true;
        }

        @Override
        public UserIdentity blockingGetUserIdentity(Redirector redirector) throws Exception {
            return null;
        }

        @Override
        public void blockingUserNotAllowed(Redirector redirector) throws Exception {
        }

        @Override
        public void blockingUserAllowed(UserIdentity userIdentity) {
        }

        @Override
        public boolean requiresNewWindow() {
            return false;
        }
    }
}

