/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.config;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.config.ConfigParameterCheckerDescriptor;
import org.ametys.runtime.config.ConfigParameterCheckerParser;
import org.ametys.runtime.config.ConfigParameterDefinitionParser;
import org.ametys.runtime.config.ConfigParameterInfo;
import org.ametys.runtime.config.ConfigParameterTypeExtensionPoint;
import org.ametys.runtime.config.DisableConditions;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.CategorizedElementDefinitionHelper;
import org.ametys.runtime.model.CategorizedElementDefinitionProxy;
import org.ametys.runtime.model.DefinitionAndValue;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.xml.XMLElementType;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class ConfigManager
implements Model,
Contextualizable,
Serviceable,
Initializable {
    private static ConfigManager __manager;
    private Logger _logger = LoggerFactory.getLogger(ConfigManager.class);
    private Logger _threadSafeComponentLogger = LoggerFactory.getLogger((String)"runtime.plugin.threadsafecomponent");
    private ServiceManager _serviceManager;
    private Context _context;
    private ThreadSafeComponentManager<Validator> _validatorManager;
    private ThreadSafeComponentManager<Enumerator> _enumeratorManager;
    private ThreadSafeComponentManager<ItemChecker> _parameterCheckerManager;
    private Map<String, ConfigParameterInfo> _declaredParams;
    private Map<String, ConfigParameterInfo> _declaredParamCheckers;
    private Collection<String> _usedParamIds;
    private Map<String, CategorizedElementDefinitionProxy> _categorizedParameterProxies;
    private Map<String, ConfigParameterCheckerDescriptor> _parameterCheckers;
    private List<ModelItem> _categorizedDefinitions;
    private Map<String, ElementDefinition> _flatDefinitions;
    private boolean _isInitialized;
    private boolean _isComplete;
    private ConfigParameterTypeExtensionPoint _configParameterTypeEP;

    private ConfigManager() {
    }

    public static ConfigManager getInstance() {
        if (__manager == null) {
            __manager = new ConfigManager();
        }
        return __manager;
    }

    public void contextualize(Context context) {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._serviceManager = manager;
        this._configParameterTypeEP = (ConfigParameterTypeExtensionPoint)this._serviceManager.lookup(ConfigParameterTypeExtensionPoint.ROLE);
    }

    public void initialize() {
        this._usedParamIds = new ArrayList<String>();
        this._declaredParams = new HashMap<String, ConfigParameterInfo>();
        this._categorizedParameterProxies = new HashMap<String, CategorizedElementDefinitionProxy>();
        this._declaredParamCheckers = new HashMap<String, ConfigParameterInfo>();
        this._parameterCheckers = new HashMap<String, ConfigParameterCheckerDescriptor>();
        this._flatDefinitions = new HashMap<String, ElementDefinition>();
        this._validatorManager = new ThreadSafeComponentManager();
        this._validatorManager.setLogger(this._threadSafeComponentLogger);
        this._validatorManager.contextualize(this._context);
        this._validatorManager.service(this._serviceManager);
        this._enumeratorManager = new ThreadSafeComponentManager();
        this._enumeratorManager.setLogger(this._threadSafeComponentLogger);
        this._enumeratorManager.contextualize(this._context);
        this._enumeratorManager.service(this._serviceManager);
        this._parameterCheckerManager = new ThreadSafeComponentManager();
        this._parameterCheckerManager.setLogger(this._threadSafeComponentLogger);
        this._parameterCheckerManager.contextualize(this._context);
        this._parameterCheckerManager.service(this._serviceManager);
    }

    public void addPluginConfig(String pluginName, Map<String, ConfigParameterInfo> parameters, Map<String, ConfigParameterInfo> parameterCheckers) {
        this._logger.debug("Adding parameters and parameters checkers for plugin {}.", (Object)pluginName);
        this._declareParameters(parameters);
        this._declareParameterCheckers(parameterCheckers);
    }

    public void addFeatureConfig(String featureId, Map<String, ConfigParameterInfo> parameters, Map<String, ConfigParameterInfo> parameterCheckers, Collection<String> parameterReferences) {
        this._logger.debug("Selecting parameters for feature {}.", (Object)featureId);
        this._declareParameters(parameters);
        this._declareParameterCheckers(parameterCheckers);
        this._usedParamIds.addAll(parameters.keySet());
        this._usedParamIds.addAll(parameterReferences);
    }

    private void _declareParameters(Map<String, ConfigParameterInfo> parameters) {
        for (String id : parameters.keySet()) {
            ConfigParameterInfo info = parameters.get(id);
            if (this._declaredParams.containsKey(id)) {
                throw new IllegalArgumentException("The config parameter '" + id + "' is already declared. Parameters ids must be unique");
            }
            this._declaredParams.put(id, info);
            this._logger.debug("Parameter added: {}", (Object)id);
        }
        this._logger.debug("{} parameter(s) added", (Object)parameters.size());
    }

    private void _declareParameterCheckers(Map<String, ConfigParameterInfo> parameterCheckers) {
        for (String id : parameterCheckers.keySet()) {
            ConfigParameterInfo info = parameterCheckers.get(id);
            if (this._declaredParamCheckers.containsKey(id)) {
                throw new IllegalArgumentException("The config parameter checker '" + id + "' is already declared. Parameter checkers ids must be unique.");
            }
            this._declaredParamCheckers.put(id, info);
            this._logger.debug("Parameter checker added: {}", (Object)id);
        }
        this._logger.debug("{} parameter checker(s) added", (Object)parameterCheckers.size());
    }

    public void parseAndValidate() {
        this._logger.debug("Initialization");
        this._isInitialized = false;
        this._isComplete = true;
        ConfigParameterDefinitionParser parser = new ConfigParameterDefinitionParser(this._configParameterTypeEP, this._enumeratorManager, this._validatorManager);
        this._parseParameters(parser);
        ConfigParameterCheckerParser parameterCheckerParser = new ConfigParameterCheckerParser(this._parameterCheckerManager);
        this._parseParameterCheckers(parameterCheckerParser);
        this._categorizeParameters();
        try {
            parser.lookupComponents();
            parameterCheckerParser.lookupComponents();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to lookup parameter local components", e);
        }
        this._validateParametersForReading();
        this._usedParamIds.clear();
        this._declaredParams.clear();
        this._declaredParamCheckers.clear();
        this._isInitialized = true;
        Config.setInitialized(this._isComplete);
        this._logger.debug("Initialization ended");
    }

    private void _parseParameters(ConfigParameterDefinitionParser parser) {
        for (String id : this._usedParamIds) {
            if (this._categorizedParameterProxies.get(id) != null) continue;
            ConfigParameterInfo parameterInfo = this._declaredParams.get(id);
            if (parameterInfo == null) {
                throw new RuntimeException("The parameter '" + id + "' is used but not declared");
            }
            CategorizedElementDefinitionProxy categorizedDefinitionProxy = null;
            try {
                categorizedDefinitionProxy = parser.parse(this._serviceManager, parameterInfo.getPluginName(), parameterInfo.getConfiguration(), ConfigManager.getInstance(), null);
            }
            catch (ConfigurationException ex) {
                throw new RuntimeException("Unable to configure the config parameter : " + id, ex);
            }
            this._categorizedParameterProxies.put(id, categorizedDefinitionProxy);
        }
    }

    private void _parseParameterCheckers(ConfigParameterCheckerParser parameterCheckerParser) {
        for (String id : this._declaredParamCheckers.keySet()) {
            boolean invalidParameters = false;
            if (this._parameterCheckers.get(id) != null) continue;
            ConfigParameterInfo info = this._declaredParamCheckers.get(id);
            ConfigParameterCheckerDescriptor parameterChecker = null;
            try {
                parameterChecker = parameterCheckerParser.parseParameterChecker(info.getPluginName(), info.getConfiguration());
            }
            catch (ConfigurationException ex) {
                throw new RuntimeException("Unable to configure the parameter checker: " + id, ex);
            }
            for (String linkedParameterPath : parameterChecker.getLinkedParamsPaths()) {
                CategorizedElementDefinitionProxy linkedParameter = null;
                linkedParameter = linkedParameterPath.startsWith("/") ? this._categorizedParameterProxies.get(linkedParameterPath.substring("/".length())) : this._categorizedParameterProxies.get(linkedParameterPath);
                if (linkedParameter != null) continue;
                invalidParameters = true;
                break;
            }
            if (invalidParameters) {
                this._logger.debug("All the configuration parameters associated to the parameter checker '{}' are not used.\nThis parameter checker will be ignored.", (Object)parameterChecker.getName());
                continue;
            }
            this._parameterCheckers.put(id, parameterChecker);
        }
    }

    private void _categorizeParameters() {
        Collection<CategorizedElementDefinitionProxy> categorizedParameterProxiesValues = this._categorizedParameterProxies.values();
        this._categorizedDefinitions = CategorizedElementDefinitionHelper.categorize(categorizedParameterProxiesValues);
        this._flatDefinitions = CategorizedElementDefinitionHelper.getFlatDefinitions(categorizedParameterProxiesValues);
        this._addParameterCheckersToModelItems();
    }

    private void _addParameterCheckersToModelItems() {
        for (ConfigParameterCheckerDescriptor parameterChecker : this._parameterCheckers.values()) {
            I18nizableText uiCategory = parameterChecker.getUiRefCategory();
            if (uiCategory != null) {
                ModelItemGroup category = this._getModelItemGroup(this._categorizedDefinitions, uiCategory);
                if (category == null) {
                    this._logger.warn("The category {} doesn't exist, thus the parameter checker {} will not be added.", (Object)uiCategory, (Object)parameterChecker.getName());
                    continue;
                }
                I18nizableText uiGroup = parameterChecker.getUiRefGroup();
                if (uiGroup == null) {
                    category.addItemChecker(parameterChecker);
                    continue;
                }
                ModelItemGroup group = this._getModelItemGroup(category.getChildren(), uiGroup);
                if (group == null) {
                    this._logger.warn("The group {} doesn't exist,  thus the parameter checker {} will not be added.", (Object)uiGroup, (Object)parameterChecker.getName());
                    continue;
                }
                group.addItemChecker(parameterChecker);
                continue;
            }
            String uiParameterId = parameterChecker.getUiRefParamId();
            if (uiParameterId == null) continue;
            ElementDefinition definition = this._flatDefinitions.get(uiParameterId);
            if (definition == null) {
                this._logger.warn("The parameter {} doesn't exist, thus the parameter checker {} will not be added.", (Object)uiParameterId, (Object)parameterChecker.getName());
                continue;
            }
            definition.addItemChecker(parameterChecker);
        }
    }

    private ModelItemGroup _getModelItemGroup(List<ModelItem> items, I18nizableText itemGroupLabel) {
        for (ModelItem item : items) {
            if (!itemGroupLabel.equals(item.getLabel()) || !(item instanceof ModelItemGroup)) continue;
            return (ModelItemGroup)item;
        }
        return null;
    }

    private void _validateParametersForReading() {
        Config.dispose();
        Map<String, DefinitionAndValue> definitionAndValues = null;
        try {
            Config.setModel(this);
            definitionAndValues = Config.__read();
        }
        catch (Exception e) {
            this._logger.error("Cannot read the configuration file.", (Throwable)e);
            this._isComplete = false;
        }
        if (this._isComplete && definitionAndValues != null) {
            for (ElementDefinition definition : this._flatDefinitions.values()) {
                boolean isGroupSwitchOn = ModelHelper.isGroupSwitchOn(definition, Config.__extractValues(definitionAndValues));
                boolean isDisabled = ModelHelper.evaluateDisableConditions(definition.getDisableConditions(), definitionAndValues, this._logger);
                if (!isGroupSwitchOn || isDisabled) continue;
                DefinitionAndValue definitionAndValue = definitionAndValues.get(definition.getName());
                if (definitionAndValue == null) {
                    this._logger.warn("The parameter '" + definition.getName() + "' is not valued. Configuration is not initialized.");
                    this._isComplete = false;
                    continue;
                }
                Object value = definitionAndValue.getValue();
                List<I18nizableText> errors = ModelHelper.validateValue(definition, value);
                if (errors.isEmpty()) continue;
                if (this._logger.isWarnEnabled()) {
                    StringBuilder sb = new StringBuilder("The parameter '" + definition.getName() + "' is not valid with value '" + value + "' :");
                    for (I18nizableText error : errors) {
                        sb.append("\n* " + error.toString());
                    }
                    sb.append("\nConfiguration is not initialized");
                    this._logger.warn(sb.toString());
                }
                this._isComplete = false;
            }
        }
    }

    public Map<String, List<I18nizableText>> save(Map<String, Object> values, String fileName) throws Exception {
        Map<String, DefinitionAndValue> oldDefinitionAndValues = this.getOldDefinitionAndValues();
        Map<String, DefinitionAndValue> definitionAndValues = this._getDefinitionAndResolvedValues(values, oldDefinitionAndValues);
        Map<String, List<I18nizableText>> errorFields = CategorizedElementDefinitionHelper.validateValuesForWriting(definitionAndValues, this._flatDefinitions, this._logger);
        if (!errorFields.isEmpty()) {
            return errorFields;
        }
        this._saxConfigurationFile(fileName, definitionAndValues);
        return Collections.EMPTY_MAP;
    }

    public Map<String, DefinitionAndValue> getOldDefinitionAndValues() {
        Map<String, DefinitionAndValue> oldDefinitionAndValues = null;
        if (Config.getInstance() == null) {
            try {
                oldDefinitionAndValues = Config.__read();
            }
            catch (Exception e) {
                oldDefinitionAndValues = new HashMap<String, DefinitionAndValue>();
            }
        }
        return oldDefinitionAndValues;
    }

    private Map<String, DefinitionAndValue> _getDefinitionAndResolvedValues(Map<String, Object> values, Map<String, DefinitionAndValue> oldDefinitionAndValues) {
        HashMap<String, DefinitionAndValue> definitionAndValues = new HashMap<String, DefinitionAndValue>();
        for (Map.Entry<String, Object> value : values.entrySet()) {
            ElementDefinition definition = this._flatDefinitions.get(value.getKey());
            if (definition == null) continue;
            Object resolvedValue = this._resolveValue(definition, value.getValue(), oldDefinitionAndValues);
            DefinitionAndValue<Object> definitionAndValue = new DefinitionAndValue<Object>(null, definition, resolvedValue);
            definitionAndValues.put(value.getKey(), definitionAndValue);
        }
        return definitionAndValues;
    }

    public String resolveValueForParameterChecker(String parameterName, Object value, Map<String, DefinitionAndValue> oldDefinitionAndValues) {
        ElementDefinition definition = this._flatDefinitions.get(parameterName);
        if (definition == null) {
            return null;
        }
        Object resolvedValue = this._resolveValue(definition, value, oldDefinitionAndValues);
        return definition.getType().toString(resolvedValue);
    }

    private Object _resolveValue(ElementDefinition definition, Object value, Map<String, DefinitionAndValue> oldDefinitionAndValues) {
        String parameterId = definition.getName();
        ElementType type = definition.getType();
        Object resolvedValue = value;
        if (value == null && "password".equals(type.getId())) {
            if (Config.getInstance() != null) {
                resolvedValue = Config.getInstance().getValue(parameterId);
            } else if (oldDefinitionAndValues != null) {
                Object oldValue = null;
                DefinitionAndValue oldDefinitionAdValue = oldDefinitionAndValues.get(definition.getName());
                if (oldDefinitionAdValue != null) {
                    oldValue = oldDefinitionAdValue.getValue();
                }
                resolvedValue = oldValue;
            }
        }
        return resolvedValue;
    }

    private void _saxConfigurationFile(String fileName, Map<String, DefinitionAndValue> definitionAndValues) throws TransformerFactoryConfigurationError, Exception {
        File outputFile = new File(fileName);
        outputFile.getParentFile().mkdirs();
        try (FileOutputStream os = new FileOutputStream(fileName);){
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            StreamResult result = new StreamResult(os);
            th.setResult(result);
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("indent", "yes");
            format.put("encoding", "UTF-8");
            format.put("{http://xml.apache.org/xalan}indent-amount", "2");
            th.getTransformer().setOutputProperties(format);
            this._saxParameters(th, Config.__extractValues(definitionAndValues));
        }
        catch (Exception e) {
            throw new Exception("An error occured while saving the config values.", e);
        }
    }

    private void _saxParameters(TransformerHandler handler, Map<String, Object> values) throws SAXException {
        handler.startDocument();
        XMLUtils.startElement((ContentHandler)handler, (String)"config");
        for (ModelItem category : this._categorizedDefinitions) {
            if (!(category instanceof ModelItemGroup)) continue;
            StringBuilder categoryLabel = new StringBuilder();
            categoryLabel.append("+\n      | ");
            categoryLabel.append(category.getLabel().toString());
            categoryLabel.append("\n      +");
            XMLUtils.data((ContentHandler)handler, (String)"\n  ");
            handler.comment(categoryLabel.toString().toCharArray(), 0, categoryLabel.length());
            XMLUtils.data((ContentHandler)handler, (String)"\n");
            XMLUtils.data((ContentHandler)handler, (String)"\n");
            Iterator<ModelItem> groups = ((ModelItemGroup)category).getChildren().iterator();
            while (groups.hasNext()) {
                ModelItem group = groups.next();
                if (!(group instanceof ModelItemGroup)) continue;
                StringBuilder groupLabel = new StringBuilder();
                groupLabel.append(" ");
                groupLabel.append(group.getLabel().toString());
                groupLabel.append(" ");
                XMLUtils.data((ContentHandler)handler, (String)"  ");
                handler.comment(groupLabel.toString().toCharArray(), 0, groupLabel.length());
                XMLUtils.data((ContentHandler)handler, (String)"\n  ");
                for (ModelItem definition : ((ModelItemGroup)group).getChildren()) {
                    if (!(definition instanceof ElementDefinition)) continue;
                    Object value = values.get(definition.getName());
                    ElementType type = ((ElementDefinition)definition).getType();
                    if (!(type instanceof XMLElementType)) continue;
                    ((XMLElementType)type).write(handler, definition.getName(), value);
                }
                if (!groups.hasNext()) continue;
                XMLUtils.data((ContentHandler)handler, (String)"\n");
            }
            XMLUtils.data((ContentHandler)handler, (String)"\n");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"config");
        handler.endDocument();
    }

    public boolean evaluateDisableConditions(DisableConditions disableConditions, Map<String, Object> values) {
        Map<String, DefinitionAndValue> definitionAndValues = this._getDefinitionAndValues(values);
        return ModelHelper.evaluateDisableConditions(disableConditions, definitionAndValues, this._logger);
    }

    private Map<String, DefinitionAndValue> _getDefinitionAndValues(Map<String, Object> values) {
        HashMap<String, DefinitionAndValue> definitionAndValues = new HashMap<String, DefinitionAndValue>();
        for (Map.Entry<String, Object> value : values.entrySet()) {
            ElementDefinition definition = this._flatDefinitions.get(value.getKey());
            if (definition == null) continue;
            DefinitionAndValue<Object> definitionAndValue = new DefinitionAndValue<Object>(null, definition, value.getValue());
            definitionAndValues.put(value.getKey(), definitionAndValue);
        }
        return definitionAndValues;
    }

    @Override
    public ModelItem getModelItem(String itemPath) {
        return this._flatDefinitions.get(itemPath);
    }

    public Collection<ElementDefinition> getConfigurationParameters() {
        return this._flatDefinitions.values();
    }

    public Collection<ModelItem> getModelItems() {
        return this._categorizedDefinitions;
    }

    public ConfigParameterCheckerDescriptor getParameterChecker(String id) {
        return this._parameterCheckers.get(id);
    }

    public boolean isComplete() {
        return this._isInitialized && this._isComplete;
    }

    public boolean isEmpty() {
        return !Config.fileExists();
    }

    public void dispose() {
        this._isInitialized = false;
        this._isComplete = true;
        this._usedParamIds = null;
        this._declaredParams = null;
        this._categorizedParameterProxies = null;
        this._declaredParamCheckers = null;
        this._parameterCheckers = null;
        this._flatDefinitions = null;
        if (this._validatorManager != null) {
            this._validatorManager.dispose();
            this._validatorManager = null;
        }
        if (this._enumeratorManager != null) {
            this._enumeratorManager.dispose();
            this._enumeratorManager = null;
        }
        if (this._parameterCheckerManager != null) {
            this._parameterCheckerManager.dispose();
            this._parameterCheckerManager = null;
        }
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public String getFamilyId() {
        return this.getClass().getName();
    }
}

