/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.checker.ItemCheckerDescriptor;
import org.apache.cocoon.ProcessingException;

public abstract class AbstractModelItem
implements ModelItem {
    private String _name;
    private I18nizableText _label;
    private I18nizableText _description;
    private Set<ItemCheckerDescriptor> _itemCheckers = new HashSet<ItemCheckerDescriptor>();
    private Model _model;
    private ModelItemGroup _parent;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    @Override
    public void addItemChecker(ItemCheckerDescriptor itemChecker) {
        this._itemCheckers.add(itemChecker);
    }

    @Override
    public Set<ItemCheckerDescriptor> getItemCheckers() {
        return Collections.unmodifiableSet(this._itemCheckers);
    }

    @Override
    public String getPath() {
        if (this.getName() == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        ModelItemGroup parent = this.getParent();
        if (parent != null && parent.getPath() != null) {
            path.append(parent.getPath()).append("/");
        }
        path.append(this.getName());
        return path.toString();
    }

    @Override
    public Model getModel() {
        return this._model;
    }

    @Override
    public void setModel(Model model) {
        this._model = model;
    }

    @Override
    public ModelItemGroup getParent() {
        return this._parent;
    }

    @Override
    public void setParent(ModelItemGroup parent) {
        this._parent = parent;
    }

    @Override
    public Map<String, Object> toJSON() throws ProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", this.getName());
        result.put("label", this.getLabel());
        result.put("description", this.getDescription());
        if (!this.getItemCheckers().isEmpty()) {
            ArrayList<Map<String, Object>> checkers2json = new ArrayList<Map<String, Object>>();
            for (ItemCheckerDescriptor paramChecker : this.getItemCheckers()) {
                checkers2json.add(paramChecker.toJSON());
            }
            result.put("field-checker", checkers2json);
        }
        return result;
    }

    @Override
    public int compareTo(ModelItem item) {
        if (item == null) {
            return 1;
        }
        String name = this.getName();
        if (name != null) {
            return name.compareTo(item.getName());
        }
        I18nizableText label = this.getLabel();
        if (label != null) {
            I18nizableText otherLabel = item.getLabel();
            if (otherLabel == null) {
                return 1;
            }
            return label.toString().compareTo(otherLabel.toString());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelItem)) {
            return false;
        }
        ModelItem item = (ModelItem)obj;
        if (this.getName() != null) {
            return this.getName().equals(item.getName());
        }
        if (this.getLabel() != null) {
            return this.getLabel().equals(item.getLabel());
        }
        return true;
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return this.getLabel().hashCode();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return this.getLabel().toString();
    }
}

