/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;

public abstract class AbstractModelItemParser {
    public ModelItem parse(ServiceManager serviceManager, String pluginName, Configuration itemConfig, Model model, ModelItemGroup parent) throws ConfigurationException {
        ModelItem modelItem = this._createModelItem(itemConfig);
        modelItem.setModel(model);
        if (parent != null) {
            parent.addChild(modelItem);
        }
        modelItem.setName(this._parseName(itemConfig));
        modelItem.setLabel(this._parseI18nizableText(itemConfig, pluginName, "label"));
        modelItem.setDescription(this._parseI18nizableText(itemConfig, pluginName, "description"));
        return modelItem;
    }

    protected abstract ModelItem _createModelItem(Configuration var1) throws ConfigurationException;

    protected String _parseName(Configuration itemConfig) throws ConfigurationException {
        String itemName = itemConfig.getAttribute(this._getNameConfigurationAttribute());
        if (!itemName.matches("^[a-zA-Z]((?!__)[a-zA-Z0-9_\\.-])*$")) {
            throw new ConfigurationException("Invalid model item name: " + itemName + ". The item name must start with a letter and must contain only letters, digits, underscore, dot or dash characters.", itemConfig);
        }
        return itemName;
    }

    protected String _getNameConfigurationAttribute() {
        return "name";
    }

    protected I18nizableText _parseI18nizableText(Configuration config, String pluginName, String name) throws ConfigurationException {
        return I18nizableText.parseI18nizableText(config.getChild(name), "plugin." + pluginName);
    }
}

