/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.config.DisableCondition;
import org.ametys.runtime.config.DisableConditions;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionAndValue;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.parameter.Errors;
import org.ametys.runtime.parameter.Validator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public final class ModelHelper {
    private ModelHelper() {
    }

    public static boolean isGroupSwitchOn(ModelItem modelItem, Map<String, Object> values) {
        Pair<Boolean, ElementDefinition> isGroupActive = ModelHelper._isModelItemGroupActive(modelItem.getParent(), values);
        if (((Boolean)isGroupActive.getKey()).booleanValue()) {
            return true;
        }
        return modelItem.equals(isGroupActive.getValue());
    }

    private static Pair<Boolean, ElementDefinition> _isModelItemGroupActive(ModelItemGroup group, Map<String, Object> values) {
        if (group == null) {
            return new ImmutablePair((Object)true, null);
        }
        ElementDefinition<Boolean> groupSwitch = group.getSwitcher();
        if (groupSwitch == null) {
            return ModelHelper._isModelItemGroupActive(group.getParent(), values);
        }
        Object value = values.get(groupSwitch.getName());
        if (value == null) {
            value = groupSwitch.getDefaultValue();
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalStateException("The switcher value of group " + group.getName() + " is null or not a boolean");
        }
        return (Boolean)value != false ? ModelHelper._isModelItemGroupActive(group.getParent(), values) : new ImmutablePair((Object)false, groupSwitch);
    }

    public static boolean evaluateDisableConditions(DisableConditions disableConditions, Map<String, DefinitionAndValue> definitionAndValues, Logger logger) {
        boolean result;
        boolean andOperator;
        if (!ModelHelper._hasDisableConditions(disableConditions)) {
            return false;
        }
        boolean disabled = andOperator = disableConditions.getAssociationType() == DisableConditions.ASSOCIATION_TYPE.AND;
        for (DisableConditions subConditions : disableConditions.getSubConditions()) {
            result = ModelHelper.evaluateDisableConditions(subConditions, definitionAndValues, logger);
            disabled = andOperator ? disabled && result : disabled || result;
        }
        for (DisableCondition condition : disableConditions.getConditions()) {
            result = ModelHelper._evaluateCondition(condition, definitionAndValues, logger);
            disabled = andOperator ? disabled && result : disabled || result;
        }
        return disabled;
    }

    private static boolean _hasDisableConditions(DisableConditions disableConditions) {
        return disableConditions != null && !disableConditions.getConditions().isEmpty() && disableConditions.getSubConditions().isEmpty();
    }

    private static boolean _evaluateCondition(DisableCondition condition, Map<String, DefinitionAndValue> definitionAndValues, Logger logger) {
        String id = condition.getId();
        DisableCondition.OPERATOR operator = condition.getOperator();
        String conditionValue = condition.getValue();
        DefinitionAndValue definitionAndValue = definitionAndValues.get(id);
        if (definitionAndValue == null || !(definitionAndValue.getDefinition() instanceof ElementDefinition)) {
            logger.debug("Cannot evaluate the disable condition on the undefined element {}.\nReturning false.", (Object)id);
            return false;
        }
        ElementType type = ((ElementDefinition)definitionAndValue.getDefinition()).getType();
        Object compareValue = type.castValue(conditionValue);
        if (compareValue == null) {
            throw new IllegalStateException("Cannot convert the condition value '" + conditionValue + "' to a '" + type.getId() + "' for model item '" + id + "'");
        }
        Object value = definitionAndValue.getValue();
        if (!(value instanceof Comparable) || !(compareValue instanceof Comparable)) {
            throw new IllegalStateException("values '" + value + "' and '" + compareValue + "' of type'" + type + "' for model item '" + id + "' are not comparable");
        }
        Comparable comparableParameterValue = (Comparable)value;
        Comparable comparableCompareValue = (Comparable)compareValue;
        int comparison = comparableParameterValue.compareTo(comparableCompareValue);
        switch (operator) {
            case NEQ: {
                return comparison != 0;
            }
            case GEQ: {
                return comparison >= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case LT: {
                return comparison < 0;
            }
            case LEQ: {
                return comparison <= 0;
            }
        }
        return comparison == 0;
    }

    public static List<I18nizableText> validateValue(ElementDefinition definition, Object value) {
        return ModelHelper.validateValue(definition, value, true);
    }

    public static List<I18nizableText> validateValue(ElementDefinition definition, Object value, boolean checkEnumerated) {
        Enumerator<Object> enumerator;
        Validator validator;
        ArrayList<I18nizableText> errorsList = new ArrayList<I18nizableText>();
        Errors errors = new Errors();
        ElementType type = definition.getType();
        if (value != null && !type.getManagedClass().isInstance(value) && !type.getManagedClassArray().isInstance(value)) {
            errorsList.add(new I18nizableText("plugin.core", "PLUGINS_CORE_ELEMENT_DEFINITION_VALUE_NOT_ALLOWED"));
        }
        if ((validator = definition.getValidator()) != null) {
            validator.validate(value, errors);
            if (errors.hasErrors()) {
                errorsList.addAll(errors.getErrors());
            }
        }
        if (checkEnumerated && (enumerator = definition.getEnumerator()) != null) {
            I18nizableText entry = null;
            try {
                entry = enumerator.getEntry(value);
            }
            catch (Exception e) {
                errorsList.add(new I18nizableText("plugin.core", "PLUGINS_CORE_ELEMENT_DEFINITION_VALUE_LED_TO_EXCEPTION"));
            }
            if (entry == null) {
                errorsList.add(new I18nizableText("plugin.core", "PLUGINS_CORE_ELEMENT_DEFINITION_VALUE_NOT_ALLOWED"));
            }
        }
        return errorsList;
    }
}

