/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model.checker;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.util.ModifiableLabelable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ItemCheckerDescriptor
extends AbstractLogEnabled
implements ModifiableLabelable {
    protected String _id;
    protected I18nizableText _description;
    protected I18nizableText _label;
    protected String _smallIconPath;
    protected String _mediumIconPath;
    protected String _largeIconPath;
    protected String _concreteClass;
    protected int _uiRefOrder;
    protected String _uiRefLocation;
    protected Set<String> _linkedParamsPaths;
    protected ItemChecker _parameterChecker;

    public void toSAX(ContentHandler handler) throws SAXException {
        XMLUtils.createElement((ContentHandler)handler, (String)"id", (String)this.getId());
        this.getLabel().toSAX(handler, "label");
        this.getDescription().toSAX(handler, "description");
        XMLUtils.createElement((ContentHandler)handler, (String)"small-icon-path", (String)this.getSmallIconPath());
        XMLUtils.createElement((ContentHandler)handler, (String)"medium-icon-path", (String)this.getMediumIconPath());
        XMLUtils.createElement((ContentHandler)handler, (String)"large-icon-path", (String)this.getLargeIconPath());
        if (this.getLinkedParamsPaths() != null) {
            String linkedParamsAsJSON = "[" + StringUtils.join((Iterable)this.getLinkedParamsPaths().parallelStream().map(s -> "\"" + s + "\"").collect(Collectors.toList()), (String)", ") + "]";
            XMLUtils.createElement((ContentHandler)handler, (String)"linked-fields", (String)linkedParamsAsJSON);
        }
        XMLUtils.createElement((ContentHandler)handler, (String)"order", (String)Integer.toString(this.getUiRefOrder()));
    }

    public Map<String, Object> toJSON() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", this.getId());
        result.put("label", this.getLabel());
        result.put("description", this.getDescription());
        result.put("small-icon-path", this.getSmallIconPath());
        result.put("medium-icon-path", this.getMediumIconPath());
        result.put("large-icon-path", this.getLargeIconPath());
        if (this.getLinkedParamsPaths() != null) {
            result.put("linked-fields", this.getLinkedParamsPaths());
        }
        result.put("order", this.getUiRefOrder());
        return result;
    }

    @Override
    public String getName() {
        return this._id;
    }

    @Deprecated
    public String getId() {
        return this._id;
    }

    @Override
    public void setName(String name) {
        this._id = name;
    }

    @Deprecated
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    public String getSmallIconPath() {
        return this._smallIconPath;
    }

    public void setSmallIconPath(String path) {
        this._smallIconPath = path;
    }

    public String getMediumIconPath() {
        return this._mediumIconPath;
    }

    public void setMediumIconPath(String path) {
        this._mediumIconPath = path;
    }

    public String getLargeIconPath() {
        return this._largeIconPath;
    }

    public void setLargeIconPath(String path) {
        this._largeIconPath = path;
    }

    public String getConcreteClass() {
        return this._concreteClass;
    }

    public void setClass(String concreteClass) {
        this._concreteClass = concreteClass;
    }

    public int getUiRefOrder() {
        return this._uiRefOrder;
    }

    public void setUiRefOrder(int uiRefOrder) {
        this._uiRefOrder = uiRefOrder;
    }

    public String getUiRefLocation() {
        return this._uiRefLocation;
    }

    public void setUiRefLocation(String uiRefLocation) {
        this._uiRefLocation = uiRefLocation;
    }

    public Set<String> getLinkedParamsPaths() {
        return this._linkedParamsPaths;
    }

    public void setLinkedParamsPaths(Set<String> linkedParamsPaths) {
        this._linkedParamsPaths = linkedParamsPaths;
    }

    public ItemChecker getParameterChecker() {
        return this._parameterChecker;
    }

    public void setParameterChecker(ItemChecker parameterChecker) {
        this._parameterChecker = parameterChecker;
    }
}

