/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.plugin.ComponentDefinition;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.ametys.runtime.plugin.ExtensionPointDefinition;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.FeatureActivator;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginIssue;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFeatureActivator
implements FeatureActivator {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, Plugin> _allPlugins;
    protected boolean _safeMode;

    AbstractFeatureActivator(Map<String, Plugin> allPlugins) {
        this._allPlugins = allPlugins;
    }

    protected Map<String, Plugin> computeActivePlugins(Collection<String> excludedPlugins, Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityCause> inactiveFeatures, Map<String, ExtensionPointDefinition> extensionPoints, Collection<PluginIssue> errors) {
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        for (String pluginName : this._allPlugins.keySet()) {
            if (!excludedPlugins.contains(pluginName)) {
                Plugin plugin = this._allPlugins.get(pluginName);
                plugins.put(pluginName, plugin);
                this._logger.info("Plugin '{}' loaded", (Object)pluginName);
                Map<String, ExtensionPointDefinition> extPoints = plugin.getExtensionPointDefinitions();
                for (String point : extPoints.keySet()) {
                    ExtensionPointDefinition definition = extPoints.get(point);
                    if (this._safeMode && !definition._safe) continue;
                    if (extensionPoints.containsKey(point)) {
                        String message = "The extension point '" + point + "', defined in the plugin '" + pluginName + "' is already defined in another plugin. ";
                        PluginIssue issue = new PluginIssue(pluginName, null, PluginIssue.PluginIssueCode.EXTENSIONPOINT_ALREADY_EXIST, definition._configuration.getLocation(), message);
                        if (!this._safeMode) {
                            this._logger.error(message);
                            errors.add(issue);
                            continue;
                        }
                        this._logger.debug("[Safe mode] {}", (Object)message);
                        continue;
                    }
                    extensionPoints.put(point, definition);
                }
                Map<String, Feature> features = plugin.getFeatures();
                for (String id : features.keySet()) {
                    Feature feature = features.get(id);
                    if (!this._safeMode || feature.isSafe()) {
                        initialFeatures.put(id, feature);
                        continue;
                    }
                    inactiveFeatures.put(id, PluginsManager.InactivityCause.NOT_SAFE);
                }
                continue;
            }
            this._logger.debug("Plugin '{}' is excluded", (Object)pluginName);
        }
        return plugins;
    }

    protected Map<String, Collection<String>> computeIncomingDeactivations(Map<String, Feature> features) {
        HashMap<String, Collection<String>> incomingDeactivations = new HashMap<String, Collection<String>>();
        for (String id : features.keySet()) {
            Feature feature = features.get(id);
            Collection<String> deactivations = feature.getDeactivations();
            for (String deactivation : deactivations) {
                ArrayList<String> deps = (ArrayList<String>)incomingDeactivations.get(deactivation);
                if (deps == null) {
                    deps = new ArrayList<String>();
                    incomingDeactivations.put(deactivation, deps);
                }
                deps.add(id);
            }
        }
        return incomingDeactivations;
    }

    protected void removeInactiveFeatures(Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityCause> inactiveFeatures, Map<String, Collection<String>> incomingDeactivations, Map<String, String> componentsConfig) {
        Iterator<String> it = initialFeatures.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            Feature feature = initialFeatures.get(id);
            if (incomingDeactivations.containsKey(id) && !incomingDeactivations.get(id).isEmpty()) {
                String deactivatingFeature = incomingDeactivations.get(id).iterator().next();
                this._logger.debug("Removing feature {} deactivated by feature {}.", (Object)id, (Object)deactivatingFeature);
                it.remove();
                inactiveFeatures.put(id, PluginsManager.InactivityCause.DEACTIVATED);
                continue;
            }
            Map<String, String> components = feature.getComponentsIds();
            for (String role : components.keySet()) {
                String componentId = components.get(role);
                String selectedId = componentsConfig.get(role);
                if (selectedId == null || selectedId.equals(componentId)) continue;
                this._logger.debug("Removing feature '{}' as it contains the component id '{}' for role '{}' but the user selected the id '{}' for that role.", new Object[]{id, componentId, role, selectedId});
                it.remove();
                inactiveFeatures.put(id, PluginsManager.InactivityCause.COMPONENT);
            }
        }
    }

    protected void removeWrongPointReferences(Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityCause> inactiveFeatures, Map<String, ExtensionPointDefinition> extensionPoints, Collection<PluginIssue> errors) {
        Set<String> ids = initialFeatures.keySet();
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next();
            Feature feature = initialFeatures.get(id);
            Map<String, Collection<String>> extensionsIds = feature.getExtensionsIds();
            boolean hasBeenRemoved = false;
            for (String point : extensionsIds.keySet()) {
                if (extensionPoints.containsKey(point)) continue;
                String message = "In feature '" + id + "' an extension references the non-existing point '" + point + "'.";
                this._logger.error(message);
                PluginIssue issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.INVALID_POINT, null, message);
                errors.add(issue);
                if (hasBeenRemoved) continue;
                it.remove();
                inactiveFeatures.put(id, PluginsManager.InactivityCause.INVALID_POINT);
                hasBeenRemoved = true;
            }
        }
    }

    protected Map<String, Feature> processOutgoingDependencies(Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityCause> inactiveFeatures, Collection<PluginIssue> errors) {
        boolean processDependencies = true;
        while (processDependencies) {
            processDependencies = false;
            Set<String> ids = initialFeatures.keySet();
            Iterator it = ids.iterator();
            block1: while (it.hasNext()) {
                String id = (String)it.next();
                Feature feature = initialFeatures.get(id);
                Collection<String> dependencies = feature.getDependencies();
                for (String dependency : dependencies) {
                    if (initialFeatures.containsKey(dependency)) continue;
                    this._logger.debug("The feature '{}' depends on '{}' which is not present. It will be ignored.", (Object)id, (Object)dependency);
                    it.remove();
                    inactiveFeatures.put(id, PluginsManager.InactivityCause.DEPENDENCY);
                    processDependencies = true;
                    continue block1;
                }
            }
        }
        LinkedHashMap<String, Feature> resultFeatures = new LinkedHashMap<String, Feature>();
        for (String featureId : initialFeatures.keySet()) {
            this._computeFeaturesDependencies(featureId, initialFeatures, resultFeatures, featureId, errors);
        }
        return resultFeatures;
    }

    private void _computeFeaturesDependencies(String featureId, Map<String, Feature> initialFeatures, Map<String, Feature> resultFeatures, String initialFeatureId, Collection<PluginIssue> errors) {
        Feature feature = initialFeatures.get(featureId);
        Collection<String> dependencies = feature.getDependencies();
        for (String dependency : dependencies) {
            if (initialFeatureId.equals(dependency)) {
                String message = "Circular dependency detected for feature: " + feature.getFeatureId();
                this._logger.error(message);
                PluginIssue issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.CIRCULAR_DEPENDENCY, null, message);
                errors.add(issue);
                continue;
            }
            if (resultFeatures.containsKey(dependency)) continue;
            this._computeFeaturesDependencies(dependency, initialFeatures, resultFeatures, initialFeatureId, errors);
        }
        resultFeatures.put(featureId, feature);
    }

    protected Map<String, Collection<String>> computeIncomingDependencies(Map<String, Feature> features) {
        HashMap<String, Collection<String>> incomingDependencies = new HashMap<String, Collection<String>>();
        for (String id : features.keySet()) {
            Feature feature = features.get(id);
            Collection<String> dependencies = feature.getDependencies();
            for (String dependency : dependencies) {
                ArrayList<String> deps = (ArrayList<String>)incomingDependencies.get(dependency);
                if (deps == null) {
                    deps = new ArrayList<String>();
                    incomingDependencies.put(dependency, deps);
                }
                deps.add(id);
            }
        }
        return incomingDependencies;
    }

    protected Map<String, Collection<String>> computeOutgoingDependencies(Map<String, Feature> features) {
        HashMap<String, Collection<String>> outgoingDependencies = new HashMap<String, Collection<String>>();
        for (String id : features.keySet()) {
            Feature feature = features.get(id);
            Collection<String> dependencies = feature.getDependencies();
            outgoingDependencies.put(id, dependencies);
        }
        return outgoingDependencies;
    }

    protected void removeUnusedPassiveFeatures(Map<String, Feature> features, Map<String, PluginsManager.InactivityCause> inactiveFeatures, Map<String, Collection<String>> incomingDependencies) {
        Set<String> ids = features.keySet();
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next();
            Feature feature = features.get(id);
            if (!feature.isPassive() || incomingDependencies.containsKey(id)) continue;
            this._logger.debug("Remove passive feature '{}'", (Object)id);
            it.remove();
            inactiveFeatures.put(id, PluginsManager.InactivityCause.PASSIVE);
        }
    }

    protected Map<String, Map<String, ExtensionDefinition>> computeExtensions(Map<String, Feature> features, Collection<PluginIssue> errors) {
        HashMap<String, Map<String, ExtensionDefinition>> extensionsDefinitions = new HashMap<String, Map<String, ExtensionDefinition>>();
        for (Feature feature : features.values()) {
            Map<String, Map<String, ExtensionDefinition>> extensionsConfs = feature.getExtensions();
            for (String point : extensionsConfs.keySet()) {
                Map<String, ExtensionDefinition> featureExtensions = extensionsConfs.get(point);
                LinkedHashMap<String, ExtensionDefinition> globalExtensions = (LinkedHashMap<String, ExtensionDefinition>)extensionsDefinitions.get(point);
                if (globalExtensions == null) {
                    globalExtensions = new LinkedHashMap<String, ExtensionDefinition>(featureExtensions);
                    extensionsDefinitions.put(point, globalExtensions);
                    continue;
                }
                for (String id : featureExtensions.keySet()) {
                    if (globalExtensions.containsKey(id)) {
                        String message = "The extension '" + id + "' to point '" + point + "' is already defined in another feature.";
                        this._logger.error(message);
                        PluginIssue issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.EXTENSION_ALREADY_EXIST, null, message);
                        errors.add(issue);
                        continue;
                    }
                    ExtensionDefinition definition = featureExtensions.get(id);
                    globalExtensions.put(id, definition);
                }
            }
        }
        return extensionsDefinitions;
    }

    protected Map<String, ComponentDefinition> computeComponents(Map<String, Feature> features, Map<String, String> componentsConfig, Collection<PluginIssue> errors) {
        HashMap<String, ComponentDefinition> components = new HashMap<String, ComponentDefinition>();
        for (Feature feature : features.values()) {
            Map<String, ComponentDefinition> featureComponents = feature.getComponents();
            for (String role : featureComponents.keySet()) {
                PluginIssue issue;
                String message;
                ComponentDefinition definition = featureComponents.get(role);
                ComponentDefinition globalDefinition = (ComponentDefinition)components.get(role);
                if (globalDefinition == null) {
                    components.put(role, definition);
                    continue;
                }
                String id = definition.getId();
                if (id.equals(globalDefinition.getId())) {
                    message = "The component for role '" + role + "' and id '" + id + "' is defined both in feature '" + definition.getPluginName() + "/" + definition.getFeatureName() + "' and in feature '" + globalDefinition.getPluginName() + "/" + globalDefinition.getFeatureName() + "'.";
                    this._logger.error(message);
                    issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.COMPONENT_ALREADY_EXIST, null, message);
                    errors.add(issue);
                    continue;
                }
                message = "The component for role '" + role + "' is defined with id '" + id + "' in the feature '" + definition.getPluginName() + "/" + definition.getFeatureName() + "' and with id '" + globalDefinition.getId() + "' in the feature '" + globalDefinition.getPluginName() + "/" + globalDefinition.getFeatureName() + "'. One of them should be chosen in the runtime.xml.";
                this._logger.error(message);
                issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.COMPONENT_ALREADY_EXIST, null, message);
                errors.add(issue);
            }
        }
        for (String role : componentsConfig.keySet()) {
            String requiredId = componentsConfig.get(role);
            ComponentDefinition definition = (ComponentDefinition)components.get(role);
            if (definition != null && definition.getId().equals(requiredId)) continue;
            String message = "The component for role '" + role + "' should point to id '" + requiredId + "' but no component match.";
            this._logger.error(message);
            PluginIssue issue = new PluginIssue(null, null, PluginIssue.PluginIssueCode.COMPONENT_NOT_DECLARED, null, message);
            errors.add(issue);
        }
        return components;
    }

    @Override
    public String fullDump(FeatureActivator.PluginsInformation pluginInfo) {
        Map<String, PluginsManager.InactivityCause> inactiveFeatures = pluginInfo.getInactiveFeatures();
        Collection<PluginIssue> errors = pluginInfo.getErrors();
        Collection<String> excludedPlugins = RuntimeConfig.getInstance().getExcludedPlugins();
        StringBuilder sb = new StringBuilder();
        for (String pluginName : this._allPlugins.keySet()) {
            Plugin plugin = this._allPlugins.get(pluginName);
            this._dumpPlugin(sb, plugin, excludedPlugins, inactiveFeatures);
        }
        if (!errors.isEmpty()) {
            sb.append("\nErrors :\n");
            errors.forEach(issue -> sb.append(issue.toString()).append('\n'));
        }
        return sb.toString();
    }

    private void _dumpPlugin(StringBuilder sb, Plugin plugin, Collection<String> excludedPlugins, Map<String, PluginsManager.InactivityCause> inactiveFeatures) {
        Collection<String> extensionPoints;
        Set<String> paramCheckers;
        String pluginName = plugin.getName();
        sb.append("Plugin ").append(pluginName);
        if (excludedPlugins.contains(pluginName)) {
            sb.append("   *** excluded ***");
        }
        sb.append('\n');
        Set<String> configParameters = plugin.getConfigParameters().keySet();
        if (!CollectionUtils.isEmpty(configParameters)) {
            sb.append("  Config parameters : \n");
            configParameters.forEach(param -> sb.append("    ").append((String)param).append('\n'));
        }
        if (!CollectionUtils.isEmpty(paramCheckers = plugin.getParameterCheckers().keySet())) {
            sb.append("  Parameters checkers : \n");
            paramCheckers.forEach(param -> sb.append("    ").append((String)param).append('\n'));
        }
        if (!CollectionUtils.isEmpty(extensionPoints = plugin.getExtensionPoints())) {
            sb.append("  Extension points : \n");
            extensionPoints.forEach(point -> sb.append("    ").append((String)point).append('\n'));
        }
        Map<String, Feature> features = plugin.getFeatures();
        for (String featureId : features.keySet()) {
            Feature feature = features.get(featureId);
            this._dumpFeature(sb, feature, inactiveFeatures);
        }
        sb.append('\n');
    }

    private void _dumpFeature(StringBuilder sb, Feature feature, Map<String, PluginsManager.InactivityCause> inactiveFeatures) {
        Map<String, Collection<String>> extensionsIds;
        Map<String, String> componentsIds;
        Set<String> featureParamCheckers;
        Collection<String> configParametersReferences;
        String featureId = feature.getFeatureId();
        sb.append("  Feature ").append(featureId);
        if (feature.isPassive()) {
            sb.append(" (passive)");
        }
        if (feature.isSafe()) {
            sb.append(" (safe)");
        }
        if (inactiveFeatures != null && inactiveFeatures.containsKey(featureId)) {
            sb.append("   *** inactive (").append((Object)inactiveFeatures.get(featureId)).append(") ***");
        }
        sb.append('\n');
        Set<String> featureConfigParameters = feature.getConfigParameters().keySet();
        if (!CollectionUtils.isEmpty(featureConfigParameters)) {
            sb.append("    Config parameters : \n");
            featureConfigParameters.forEach(param -> sb.append("      ").append((String)param).append('\n'));
        }
        if (!CollectionUtils.isEmpty(configParametersReferences = feature.getConfigParametersReferences())) {
            sb.append("    Config parameters references : \n");
            configParametersReferences.forEach(param -> sb.append("      ").append((String)param).append('\n'));
        }
        if (!CollectionUtils.isEmpty(featureParamCheckers = feature.getParameterCheckers().keySet())) {
            sb.append("    Parameters checkers : \n");
            featureParamCheckers.forEach(param -> sb.append("    ").append((String)param).append('\n'));
        }
        if (!(componentsIds = feature.getComponentsIds()).isEmpty()) {
            sb.append("    Components : \n");
            for (String role : componentsIds.keySet()) {
                String id2 = componentsIds.get(role);
                sb.append("      ").append(role).append(" : ").append(id2).append('\n');
            }
            sb.append('\n');
        }
        if (!(extensionsIds = feature.getExtensionsIds()).isEmpty()) {
            sb.append("    Extensions : \n");
            for (Map.Entry<String, Collection<String>> extensionEntry : extensionsIds.entrySet()) {
                String point = extensionEntry.getKey();
                Collection<String> ids = extensionEntry.getValue();
                sb.append("      ").append(point).append(" :\n");
                ids.forEach(id -> sb.append("        ").append((String)id).append('\n'));
            }
            sb.append('\n');
        }
    }
}

