/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PluginsGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"list");
        Map<String, Plugin> plugins = PluginsManager.getInstance().getPlugins();
        Map<String, Feature> activeFeatures = PluginsManager.getInstance().getFeatures();
        Map<String, PluginsManager.InactivityCause> inactiveFeatures = PluginsManager.getInstance().getInactiveFeatures();
        this._saxPlugins(plugins, activeFeatures, inactiveFeatures);
        this._saxExtensionPoints();
        this._saxComponents();
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"list");
        this.contentHandler.endDocument();
    }

    private void _saxPlugins(Map<String, Plugin> plugins, Map<String, Feature> activeFeatures, Map<String, PluginsManager.InactivityCause> inactiveFeatures) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"plugins");
        for (String pluginName : plugins.keySet()) {
            AttributesImpl psAttrs = new AttributesImpl();
            psAttrs.addCDATAAttribute("name", pluginName);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"plugin", (Attributes)psAttrs);
            Plugin plugin = plugins.get(pluginName);
            Map<String, Feature> features = plugin.getFeatures();
            for (String featureId : features.keySet()) {
                Feature feature = features.get(featureId);
                if (activeFeatures.containsKey(featureId)) {
                    AttributesImpl pAttrs = new AttributesImpl();
                    pAttrs.addCDATAAttribute("name", feature.getFeatureName());
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"feature", (Attributes)pAttrs);
                    Map<String, Collection<String>> exts = feature.getExtensionsIds();
                    for (String extensionPoint : exts.keySet()) {
                        AttributesImpl epAttrs = new AttributesImpl();
                        epAttrs.addCDATAAttribute("name", extensionPoint);
                        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"extensionPoint", (Attributes)epAttrs);
                        for (String extension : exts.get(extensionPoint)) {
                            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"extension", (String)extension);
                        }
                        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"extensionPoint");
                    }
                    Map<String, String> componentsIds = feature.getComponentsIds();
                    for (String componentRole : componentsIds.keySet()) {
                        String component = componentsIds.get(componentRole);
                        AttributesImpl cmpAttrs = new AttributesImpl();
                        cmpAttrs.addCDATAAttribute("role", componentRole);
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"component", (Attributes)cmpAttrs, (String)component);
                    }
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"feature");
                    continue;
                }
                PluginsManager.InactivityCause cause = inactiveFeatures.get(featureId);
                AttributesImpl pAttrs = new AttributesImpl();
                pAttrs.addCDATAAttribute("name", feature.getFeatureName());
                pAttrs.addCDATAAttribute("inactive", "true");
                pAttrs.addCDATAAttribute("cause", cause.toString());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"feature", (Attributes)pAttrs);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"plugin");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"plugins");
    }

    private void _saxExtensionPoints() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"extension-points");
        for (String extPoint : PluginsManager.getInstance().getExtensionPoints().keySet()) {
            AttributesImpl ePAttrs = new AttributesImpl();
            ePAttrs.addCDATAAttribute("id", extPoint);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"extension-point", (Attributes)ePAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"extension-points");
    }

    private void _saxComponents() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"components");
        for (String componentRole : PluginsManager.getInstance().getComponents()) {
            AttributesImpl cmpAttrs = new AttributesImpl();
            cmpAttrs.addCDATAAttribute("id", componentRole);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"component", (Attributes)cmpAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"components");
    }
}

