/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.datasource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.DataSourceClientInteraction;
import org.ametys.core.datasource.LDAPDataSourceManager;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.impl.datasource.StaticSQLDatabaseType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class CheckDataSourceAction
extends ServiceableAction {
    private static final String __SQL_DATASOURCE_CHECKER_ID = "sql-connection-checker-datasource";
    private SQLDataSourceManager _sqlDataSourceManager;
    private LDAPDataSourceManager _ldapDataSourceManager;
    private SQLDatabaseTypeManager _sqlDatabaseTypeManager;
    private SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;
    private I18nUtils _i18nUtils;
    private JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._ldapDataSourceManager = (LDAPDataSourceManager)serviceManager.lookup(LDAPDataSourceManager.ROLE);
        this._sqlDataSourceManager = (SQLDataSourceManager)serviceManager.lookup(SQLDataSourceManager.ROLE);
        this._sqlDatabaseTypeManager = (SQLDatabaseTypeManager)serviceManager.lookup(SQLDatabaseTypeManager.ROLE);
        this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)serviceManager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)serviceManager.lookup(I18nUtils.ROLE));
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String fieldCheckersInfoJSON = request.getParameter("fieldCheckersInfo");
        Map<String, Object> fieldCheckersInfo = this._jsonUtils.convertJsonToMap(fieldCheckersInfoJSON);
        for (String fieldCheckerId : fieldCheckersInfo.keySet()) {
            Map fieldCheckerInfo = (Map)fieldCheckersInfo.get(fieldCheckerId);
            List values = (List)fieldCheckerInfo.get("rawTestValues");
            String type = fieldCheckerId.equals(__SQL_DATASOURCE_CHECKER_ID) ? "SQL" : "LDAP";
            DataSourceClientInteraction.DataSourceType dsType = DataSourceClientInteraction.DataSourceType.valueOf(type);
            try {
                switch (dsType) {
                    case SQL: {
                        this._checkSQLParameters(values);
                        break;
                    }
                    case LDAP: {
                        this._checkLDAPParameters(values);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknow data source of type '" + type + "'. Unable to check data source parameters.");
                    }
                }
            }
            catch (Throwable t) {
                this.getLogger().error("Data source test failed: \n" + t.getMessage(), t);
                String msg = t.getMessage() != null ? t.getMessage() : "Unknown error";
                result.put(fieldCheckerId, msg);
            }
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return result;
    }

    private void _checkSQLParameters(List<Object> values) throws ItemCheckerTestFailureException {
        HashMap<String, Object> sqlParameters = new HashMap<String, Object>();
        String driverExtensionId = (String)values.get(1);
        StaticSQLDatabaseType sqlDatabaseType = (StaticSQLDatabaseType)this._sqlDatabaseTypeExtensionPoint.getExtension(driverExtensionId);
        String driver = sqlDatabaseType.getDriver();
        sqlParameters.put("driver", driverExtensionId);
        if (StringUtils.isNotEmpty((String)driver)) {
            I18nizableText driverNotFoundMessageKey = this._sqlDatabaseTypeManager.getClassNotFoundMessage(driver);
            sqlParameters.put("driverNotFoundMessage", this._i18nUtils.translate(driverNotFoundMessageKey));
        }
        sqlParameters.put("url", values.get(2));
        sqlParameters.put("user", values.get(3));
        String password = (String)values.get(4);
        if (password == null) {
            String dataSourceId = (String)values.get(0);
            AbstractDataSourceManager.DataSourceDefinition dataSourceDefinition = this._sqlDataSourceManager.getDataSourceDefinition(dataSourceId);
            if (dataSourceDefinition != null) {
                sqlParameters.put("password", dataSourceDefinition.getParameters().get("password"));
            }
        } else {
            sqlParameters.put("password", password);
        }
        this._sqlDataSourceManager.checkParameters(sqlParameters);
    }

    private void _checkLDAPParameters(List<Object> values) throws ItemCheckerTestFailureException {
        HashMap<String, Object> ldapParameters = new HashMap<String, Object>();
        ldapParameters.put("baseURL", values.get(1));
        ldapParameters.put("baseDN", values.get(2));
        ldapParameters.put("useSSL", values.get(3));
        ldapParameters.put("followReferrals", values.get(4));
        String authenticationMethod = (String)values.get(5);
        ldapParameters.put("authenticationMethod", authenticationMethod);
        ldapParameters.put("adminDN", values.get(6));
        String adminPassword = (String)values.get(7);
        if (adminPassword == null && !authenticationMethod.equals("none")) {
            String dataSourceId = (String)values.get(0);
            AbstractDataSourceManager.DataSourceDefinition dataSourceDefinition = this._ldapDataSourceManager.getDataSourceDefinition(dataSourceId);
            if (dataSourceDefinition != null) {
                ldapParameters.put("adminPassword", dataSourceDefinition.getParameters().get("adminPassword"));
            }
        } else {
            ldapParameters.put("adminPassword", adminPassword);
        }
        this._ldapDataSourceManager.checkParameters(ldapParameters);
    }
}

