/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts;

import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts.AlertSampleManager;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.AbstractSampleManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public abstract class AbstractAlertSampleManager
extends AbstractSampleManager
implements AlertSampleManager {
    protected I18nizableText _subject;
    protected I18nizableText _body;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._subject = I18nizableText.parseI18nizableText(configuration.getChild("mailSubject"), "plugin." + this._pluginName);
        this._body = I18nizableText.parseI18nizableText(configuration.getChild("mailBody"), "plugin." + this._pluginName);
    }

    @Override
    public Map<String, AlertSampleManager.Threshold> getThresholdValues() {
        if (Config.getInstance() == null) {
            return null;
        }
        HashMap<String, AlertSampleManager.Threshold> result = new HashMap<String, AlertSampleManager.Threshold>();
        Map<String, String> configNames = this.getThresholdConfigNames();
        Map<String, AlertSampleManager.Threshold.Operator> operators = this.getOperators();
        for (String datasourceName : configNames.keySet()) {
            String configName = configNames.get(datasourceName);
            Object value = Config.getInstance().getValue(configName);
            result.put(datasourceName, new AlertSampleManager.Threshold(operators.get(datasourceName), datasourceName, value, this._subject, this._body));
        }
        return result;
    }

    protected abstract Map<String, String> getThresholdConfigNames();

    protected abstract Map<String, AlertSampleManager.Threshold.Operator> getOperators();
}

