/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.ui.Callable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SystemHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ADMINISTRATOR_SYSTEM_FILE = "administrator/system.xml";
    public static final String ROLE = SystemHelper.class.getName();
    private org.ametys.core.util.I18nUtils _i18nUtils;
    private Context _context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._i18nUtils = (org.ametys.core.util.I18nUtils)((Object)serviceManager.lookup(org.ametys.core.util.I18nUtils.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable
    public void setAnnouncementAvailable(boolean available) throws ProcessingException {
        SystemAnnouncement systemAnnouncement = this.readValues();
        this._save(available, systemAnnouncement.getMessages());
    }

    @Callable
    public Map<String, Object> editAnnouncement(String language, String message, boolean override) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SystemAnnouncement sytemAnnouncement = this.readValues();
        Map<String, String> messages = sytemAnnouncement.getMessages();
        if (messages.containsKey(language) && !override) {
            result.put("already-exists", true);
            return result;
        }
        messages.put(language, message);
        this._save(sytemAnnouncement.isAvailable(), messages);
        return result;
    }

    @Callable
    public Map deleteAnnouncement(String language) throws ProcessingException {
        HashMap result = new HashMap();
        SystemAnnouncement sytemAnnouncement = this.readValues();
        Map<String, String> messages = sytemAnnouncement.getMessages();
        if (messages.containsKey(language)) {
            messages.remove(language);
            this._save(sytemAnnouncement.isAvailable(), messages);
        }
        return result;
    }

    private void _save(boolean state, Map<String, String> messages) throws ProcessingException {
        File systemFile = new File(RuntimeConfig.getInstance().getAmetysHome(), ADMINISTRATOR_SYSTEM_FILE);
        try {
            if (!systemFile.exists()) {
                systemFile.getParentFile().mkdirs();
                systemFile.createNewFile();
            }
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            try (FileOutputStream os = new FileOutputStream(systemFile);){
                StreamResult sResult = new StreamResult(os);
                th.setResult(sResult);
                Properties format = new Properties();
                format.put("method", "xml");
                format.put("indent", "yes");
                format.put("encoding", "UTF-8");
                th.getTransformer().setOutputProperties(format);
                th.startDocument();
                AttributesImpl announcementsAttrs = new AttributesImpl();
                announcementsAttrs.addAttribute("", "state", "state", "CDATA", state ? "on" : "off");
                XMLUtils.startElement((ContentHandler)th, (String)"announcements", (Attributes)announcementsAttrs);
                for (String id : messages.keySet()) {
                    AttributesImpl announcementAttrs = new AttributesImpl();
                    if (!"*".equals(id)) {
                        announcementAttrs.addAttribute("", "lang", "lang", "CDATA", id);
                    }
                    XMLUtils.createElement((ContentHandler)th, (String)"announcement", (Attributes)announcementAttrs, (String)messages.get(id));
                }
                XMLUtils.endElement((ContentHandler)th, (String)"announcements");
                th.endDocument();
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to save system announcement values", (Throwable)e);
        }
    }

    @Callable
    public boolean isSystemAnnouncementAvailable() {
        SystemAnnouncement systemAnnouncement = this.readValues();
        return systemAnnouncement.isAvailable();
    }

    public long getSystemAnnoucementLastModificationDate() {
        try {
            File systemFile = new File(RuntimeConfig.getInstance().getAmetysHome(), ADMINISTRATOR_SYSTEM_FILE);
            if (!systemFile.exists() || !systemFile.isFile()) {
                return 0L;
            }
            return systemFile.lastModified();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get system announcements", e);
        }
    }

    public String getSystemAnnouncement(String languageCode) {
        SystemAnnouncement systemAnnouncement = this.readValues();
        if (!systemAnnouncement.isAvailable()) {
            return null;
        }
        Map<String, String> messages = systemAnnouncement.getMessages();
        String announcement = null;
        if (messages.containsKey(languageCode)) {
            announcement = messages.get(languageCode);
        }
        if (StringUtils.isEmpty(announcement)) {
            String defaultAnnouncement;
            String string = defaultAnnouncement = messages.containsKey("*") ? messages.get("*") : null;
            if (StringUtils.isEmpty((String)defaultAnnouncement)) {
                throw new IllegalStateException("There must be a default announcement.");
            }
            return defaultAnnouncement;
        }
        return announcement;
    }

    public SystemAnnouncement readValues() {
        SystemAnnouncement announcement = new SystemAnnouncement();
        try {
            Configuration configuration;
            File systemFile = new File(RuntimeConfig.getInstance().getAmetysHome(), ADMINISTRATOR_SYSTEM_FILE);
            if (!systemFile.exists() || !systemFile.isFile()) {
                this._setDefaultValues();
            }
            try (FileInputStream is = new FileInputStream(systemFile);){
                configuration = new DefaultConfigurationBuilder().build((InputStream)is);
            }
            String state = configuration.getAttribute("state", "off");
            boolean isAvailable = "on".equals(state);
            announcement.setAvailable(isAvailable);
            for (Configuration announcementConfiguration : configuration.getChildren("announcement")) {
                String lang = announcementConfiguration.getAttribute("lang", "*");
                String message = announcementConfiguration.getValue();
                announcement.addMessage(lang, message);
            }
            return announcement;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get system announcements", e);
        }
    }

    private void _setDefaultValues() throws ProcessingException {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Locale locale = I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
        String defaultMessage = this._i18nUtils.translate(new I18nizableText("plugin.admin", "PLUGINS_ADMIN_SYSTEM_DEFAULTMESSAGE"), locale.getLanguage());
        HashMap<String, String> messages = new HashMap<String, String>();
        messages.put("*", defaultMessage);
        this._save(false, messages);
    }

    public class SystemAnnouncement {
        private boolean _available = false;
        private Map<String, String> _messages = new HashMap<String, String>();

        public boolean isAvailable() {
            return this._available;
        }

        public Map<String, String> getMessages() {
            return this._messages;
        }

        public void setAvailable(boolean available) {
            this._available = available;
        }

        public void addMessage(String lang, String message) {
            this._messages.put(lang, message);
        }
    }
}

