/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.workspace;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;

public class Workspace {
    private String _name;
    private Configuration _configuration;
    private String _theme;
    private String _themeLocation;
    private String _themeURL;
    private String _baseURI;
    private File _location;
    private Set<String> _tags;

    Workspace(String name, String baseURI) {
        this._name = name;
        this._baseURI = baseURI;
    }

    Workspace(String name, File location) {
        this._name = name;
        this._location = location;
    }

    public String getName() {
        return this._name;
    }

    public String getEmbededLocation() {
        return this._baseURI;
    }

    public File getExternalLocation() {
        return this._location;
    }

    public String getThemeName() {
        return this._theme;
    }

    public String getThemeLocation() {
        return this._themeLocation;
    }

    public String getThemeURL() {
        return this._themeURL;
    }

    public Set<String> getTags() {
        return this._tags;
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    void configure(Configuration configuration) {
        this._configuration = configuration;
        Configuration themeConfiguration = configuration.getChild("theme");
        this._theme = StringUtils.defaultString((String)RuntimeConfig.getInstance().getOverridenThemes().get(this.getName()), (String)themeConfiguration.getAttribute("name", "ametys-base"));
        this._themeLocation = themeConfiguration.getAttribute("location", "plugin:core-ui://resources/themes/theme-" + this._theme);
        this._themeURL = themeConfiguration.getAttribute("url", "/plugins/core-ui/resources/themes/theme-" + this._theme);
        HashSet<String> tags = new HashSet<String>();
        for (Configuration tagConfiguration : configuration.getChild("tags").getChildren("tag")) {
            String tag = tagConfiguration.getValue("");
            if (!StringUtils.isNotBlank((CharSequence)tag)) continue;
            tags.add(tag);
        }
        this._tags = Collections.unmodifiableSet(tags);
    }
}

