/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.workspace;

import java.util.Map;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.runtime.workspace.Workspace;
import org.ametys.runtime.workspace.WorkspaceManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.matching.WildcardURIMatcher;
import org.apache.cocoon.sitemap.PatternException;

public class WorkspaceMatcher
extends WildcardURIMatcher {
    public static final String WORKSPACE_NAME = "workspaceName";
    public static final String WORKSPACE_URI = "workspaceURI";
    public static final String IN_WORKSPACE_URL = "inWorkspaceURL";
    public static final String WORKSPACE_THEME = "workspaceTheme";
    public static final String WORKSPACE_THEME_URL = "workspaceThemeURL";

    protected int getWildcardStartIndex() {
        return 1;
    }

    protected Workspace getWorkspace(String workspaceName) {
        WorkspaceManager wm = WorkspaceManager.getInstance();
        return wm.getWorkspaces().get(workspaceName);
    }

    public Map match(String pattern, Map objectModel, Parameters parameters) throws PatternException {
        Map result = super.match(pattern, objectModel, parameters);
        if (result == null) {
            return null;
        }
        int wildcardStartIndex = this.getWildcardStartIndex();
        boolean defaultWorkspace = "true".equals(parameters.getParameter("default", null));
        String workspaceName = defaultWorkspace ? RuntimeConfig.getInstance().getDefaultWorkspace() : (String)result.get(Integer.toString(wildcardStartIndex));
        Workspace workspace = this.getWorkspace(workspaceName);
        if (workspace == null) {
            return null;
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(WORKSPACE_NAME, (Object)workspaceName);
        request.setAttribute(WORKSPACE_URI, (Object)(defaultWorkspace ? "" : "/_" + workspaceName));
        request.setAttribute(IN_WORKSPACE_URL, result.get(Integer.toString(wildcardStartIndex + (defaultWorkspace ? 0 : 1))));
        request.setAttribute(WORKSPACE_THEME, (Object)workspace.getThemeName());
        request.setAttribute(WORKSPACE_THEME_URL, (Object)workspace.getThemeURL());
        result.put(WORKSPACE_NAME, workspaceName);
        return result;
    }
}

