/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.workspace;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.ametys.runtime.workspace.WorkspaceManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;

public class WorkspaceSourceFactory
implements SourceFactory,
Serviceable {
    private static final String __PROTOCOL_SEPARATOR = "://";
    private SourceResolver _resolver;

    public Source getSource(String location, Map parameters) throws IOException {
        int protocolIndex = location.indexOf(__PROTOCOL_SEPARATOR);
        if (protocolIndex == -1) {
            throw new MalformedURLException("URI must be like workspace:<workspace name>://path/to/resource. Location was '" + location + "'");
        }
        int index = location.indexOf(58);
        if (index == protocolIndex) {
            throw new MalformedURLException("URI must be like workspace:<workspace name>://path/to/resource. Location was '" + location + "'");
        }
        String path = location.substring(protocolIndex + 2);
        String workspaceName = location.substring(index + 1, protocolIndex);
        String resourceURI = WorkspaceManager.getInstance().getBaseURI(workspaceName);
        if (resourceURI == null) {
            File pluginLocation = WorkspaceManager.getInstance().getLocation(workspaceName);
            return new FileSource("file", new File(pluginLocation, path));
        }
        return this._resolver.resolveURI("resource:/" + resourceURI + path);
    }

    public void release(Source source) {
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }
}

