/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.ConfigurableServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public abstract class AbstractMultiAction
extends ConfigurableServiceableAction {
    private static final String ACTION_METHOD_PREFIX = "do";
    private static final String ACTION_METHOD_PARAMETER = "method";
    private HashMap methodIndex;

    private static final String removePrefix(String name) {
        int prefixLen = ACTION_METHOD_PREFIX.length();
        return name.substring(prefixLen, prefixLen + 1).toLowerCase() + name.substring(prefixLen + 1);
    }

    @Override
    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        try {
            Method[] methods = this.getClass().getMethods();
            this.methodIndex = new HashMap();
            for (int i = 0; i < methods.length; ++i) {
                String methodName = methods[i].getName();
                if (!methodName.startsWith(ACTION_METHOD_PREFIX)) continue;
                String actionName = AbstractMultiAction.removePrefix(methodName);
                this.methodIndex.put(actionName, methods[i]);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("registered method \"" + methodName + "\" as action \"" + actionName + "\"");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("cannot get methods by reflection", (Throwable)e);
        }
    }

    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request req;
        String actionMethod = parameters.getParameter(ACTION_METHOD_PARAMETER, null);
        if (actionMethod == null && (req = ObjectModelHelper.getRequest(objectModel)) != null) {
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith(ACTION_METHOD_PREFIX)) continue;
                if (name.endsWith(".x") || name.endsWith(".y")) {
                    name = name.substring(ACTION_METHOD_PREFIX.length(), name.length() - 2);
                }
                actionMethod = AbstractMultiAction.removePrefix(name);
                break;
            }
        }
        if (actionMethod != null && actionMethod.length() > 0) {
            Method method = (Method)this.methodIndex.get(actionMethod);
            if (method != null) {
                try {
                    return (Map)method.invoke((Object)this, redirector, resolver, objectModel, source, parameters);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getTargetException() != null && ite.getTargetException() instanceof Exception) {
                        throw (Exception)ite.getTargetException();
                    }
                    throw ite;
                }
            }
            throw new Exception("action has no method \"" + actionMethod + "\"");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("you need to specify the method with parameter \"method\" or have a request parameter starting with \"do\"");
        }
        return null;
    }
}

