/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractConfigurableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class HttpCacheAction
extends AbstractConfigurableAction
implements ThreadSafe {
    private FastDateFormat formatter = null;
    int days = 0;
    int hours = 0;
    int minutes = 0;
    int seconds = 0;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.formatter = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy kk:mm:ss zzz", (TimeZone)DateUtils.UTC_TIME_ZONE);
        this.days = configuration.getChild("days").getValueAsInteger(0);
        this.hours = configuration.getChild("hours").getValueAsInteger(0);
        this.minutes = configuration.getChild("minutes").getValueAsInteger(0);
        this.seconds = configuration.getChild("seconds").getValueAsInteger(0);
    }

    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Response response = ObjectModelHelper.getResponse(objectModel);
        Calendar calendar = Calendar.getInstance(DateUtils.UTC_TIME_ZONE);
        HashMap<String, String> values = new HashMap<String, String>(3);
        String value = this.formatter.format(calendar);
        long maxage = calendar.getTime().getTime();
        response.setHeader("Last-Modified", value);
        values.put("last-modified", value);
        calendar.add(5, this.days);
        calendar.add(10, this.hours);
        calendar.add(12, this.minutes);
        calendar.add(13, this.seconds);
        maxage = calendar.getTime().getTime() - maxage;
        if (maxage > 1000L) {
            value = this.formatter.format(calendar);
            response.setHeader("Expires", value);
            values.put("expires", value);
            value = "max-age=" + Long.toString(maxage / 1000L);
            response.setHeader("Cache-Control", value);
            values.put("cache-control", value);
        } else {
            response.setHeader("Expires", value);
            values.put("expires", value);
            response.setHeader("Cache-Control", "no-cache");
            values.put("cache-control", "no-cache");
        }
        return Collections.unmodifiableMap(values);
    }
}

