/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class SetterAction
extends AbstractAction
implements Parameterizable,
ThreadSafe {
    public static final int MODE_OBJECT_MODEL = 1;
    public static final int MODE_REQUEST_ATTR = 2;
    public static final int MODE_SESSION_ATTR = 3;
    public static final String MODEDEF_OBJECT_MODEL = "object-model";
    public static final String MODEDEF_REQUEST_ATTR = "request-attribute";
    public static final String MODEDEF_SESSION_ATTR = "session-attribute";
    protected int mode = 1;

    public void parameterize(Parameters params) throws ParameterException {
        String modeDef = params.getParameter("mode", null);
        if (modeDef != null) {
            if (MODEDEF_OBJECT_MODEL.equals(modeDef)) {
                this.mode = 1;
            } else if (MODEDEF_REQUEST_ATTR.equals(modeDef)) {
                this.mode = 2;
            } else if (MODEDEF_SESSION_ATTR.equals(modeDef)) {
                this.mode = 3;
            } else {
                throw new ParameterException("Unknown mode: " + this.mode);
            }
        }
    }

    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String[] names = parameters.getNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (this.mode == 1) {
                objectModel.put(name, parameters.getParameter(name));
                continue;
            }
            if (this.mode == 2) {
                ObjectModelHelper.getRequest(objectModel).setAttribute(name, parameters.getParameter(name));
                continue;
            }
            if (this.mode != 3) continue;
            ObjectModelHelper.getRequest(objectModel).getSession().setAttribute(name, parameters.getParameter(name));
        }
        return EMPTY_MAP;
    }
}

