/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.logger.LogKitLoggerManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.CocoonAccess;
import org.apache.cocoon.Constants;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.commandline.CommandLineContext;
import org.apache.cocoon.environment.commandline.FileSavingEnvironment;
import org.apache.cocoon.environment.commandline.LinkSamplingEnvironment;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.IOUtils;
import org.apache.cocoon.util.NetUtils;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.commons.lang.SystemUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Priority;
import org.xml.sax.ContentHandler;

public class CocoonWrapper {
    protected static final String DEFAULT_USER_AGENT = Constants.COMPLETE_NAME;
    protected static final String DEFAULT_ACCEPT = "text/html, */*";
    private String contextDir = "./webapp";
    private String configFile = null;
    private String workDir = "./work";
    private String logKit = null;
    protected String logger = null;
    protected String logLevel = "ERROR";
    protected String userAgent = DEFAULT_USER_AGENT;
    protected String accept = "text/html, */*";
    private List classList = new ArrayList();
    protected File context;
    private File work;
    private File conf;
    protected CommandLineContext cliContext;
    private LogKitLoggerManager logManager;
    protected Cocoon cocoon;
    protected Logger log;
    private HashMap empty = new HashMap();
    private boolean initialized = false;
    private boolean useExistingCocoon = false;

    public void initialize() throws Exception {
        Hierarchy hierarchy = new Hierarchy();
        Priority priority = Priority.getPriorityForName((String)this.logLevel);
        hierarchy.setDefaultPriority(priority);
        this.log = new LogKitLogger(hierarchy.getLoggerFor(""));
        try {
            this.context = this.getDir(this.contextDir, "context");
            this.work = this.getDir(this.workDir, "working");
            DefaultContext appContext = new DefaultContext();
            appContext.put((Object)"work-directory", (Object)this.work);
            this.logManager = new LogKitLoggerManager(hierarchy);
            this.logManager.enableLogging(this.log);
            if (this.logKit != null) {
                FileInputStream fis = new FileInputStream(this.logKit);
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration logKitConf = builder.build((InputStream)fis);
                DefaultContext subcontext = new DefaultContext((Context)appContext);
                subcontext.put((Object)"context-root", (Object)this.contextDir);
                subcontext.put((Object)"context-work", (Object)this.workDir);
                this.logManager.contextualize((Context)subcontext);
                this.logManager.configure(logKitConf);
                this.log = this.logger != null ? this.logManager.getLoggerForCategory(this.logger) : this.logManager.getLoggerForCategory("cocoon");
            }
            this.conf = this.getConfigurationFile(this.context, this.configFile);
            this.cliContext = new CommandLineContext(this.contextDir);
            this.cliContext.enableLogging(this.log);
            appContext.put((Object)"environment-context", (Object)this.cliContext);
            appContext.put((Object)"class-loader", (Object)CocoonWrapper.class.getClassLoader());
            appContext.put((Object)"classpath", (Object)this.getClassPath(this.contextDir));
            appContext.put((Object)"upload-directory", (Object)(this.contextDir + "upload-dir"));
            File cacheDir = this.getDir(this.workDir + File.separator + "cache-dir", "cache");
            appContext.put((Object)"cache-directory", (Object)cacheDir);
            appContext.put((Object)"config-url", (Object)this.conf.toURL());
            appContext.put((Object)"default-encoding", (Object)"ISO-8859-1");
            this.loadClasses(this.classList);
            if (this.useExistingCocoon) {
                this.cocoon = this.getCocoon();
            }
            if (this.cocoon == null) {
                this.cocoon = new Cocoon();
                ContainerUtil.enableLogging((Object)this.cocoon, (Logger)this.log);
                ContainerUtil.contextualize((Object)this.cocoon, (Context)appContext);
                this.cocoon.setLoggerManager((LoggerManager)this.logManager);
                ContainerUtil.initialize((Object)this.cocoon);
            }
        }
        catch (Exception e) {
            this.log.fatalError("Exception caught", (Throwable)e);
            throw e;
        }
        this.initialized = true;
    }

    private Cocoon getCocoon() {
        return new CocoonInstance().instance();
    }

    protected ExcaliburComponentManager getComponentManager() {
        return this.cocoon.getComponentManager();
    }

    private File getConfigurationFile(File dir, String configFile) throws IOException {
        File conf;
        if (configFile == null) {
            conf = this.tryConfigurationFile(dir + File.separator + "cocoon.xconf");
            if (conf == null) {
                conf = this.tryConfigurationFile(dir + File.separator + "WEB-INF" + File.separator + "cocoon.xconf");
            }
            if (conf == null) {
                conf = this.tryConfigurationFile(SystemUtils.USER_DIR + File.separator + "cocoon.xconf");
            }
            if (conf == null) {
                conf = this.tryConfigurationFile("/usr/local/etc/cocoon.xconf");
            }
        } else {
            conf = new File(configFile);
            if (!conf.exists()) {
                conf = new File(dir, configFile);
            }
        }
        if (conf == null) {
            this.log.error("Could not find the configuration file.");
            throw new FileNotFoundException("The configuration file could not be found.");
        }
        return conf;
    }

    private File tryConfigurationFile(String filename) {
        File conf;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Trying configuration file at: " + filename);
        }
        if ((conf = new File(filename)).canRead()) {
            return conf;
        }
        return null;
    }

    private File getDir(String dir, String type) throws IOException {
        File d;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting handle to " + type + " directory '" + dir + "'");
        }
        if (!(d = new File(dir)).exists() && !d.mkdirs()) {
            throw new IOException("Error creating " + type + " directory '" + d + "'");
        }
        if (!d.isDirectory()) {
            throw new IOException("'" + d + "' is not a directory.");
        }
        if (!d.canRead()) {
            throw new IOException("Directory '" + d + "' is not readable");
        }
        if ("working".equals(type) && !d.canWrite()) {
            throw new IOException("Directory '" + d + "' is not writable");
        }
        return d;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    protected void loadClasses(List classList) {
        if (classList != null) {
            for (String className : classList) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Trying to load class: " + className);
                    }
                    ClassUtils.loadClass(className).newInstance();
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("Could not force-load class: " + className, (Throwable)e);
                }
            }
        }
    }

    public void setLogKit(String logKit) {
        this.logKit = logKit;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getLoggerName() {
        return this.logger;
    }

    public void setContextDir(String contextDir) {
        this.contextDir = contextDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setAgentOptions(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setAcceptOptions(String accept) {
        this.accept = accept;
    }

    public void addLoadedClass(String className) {
        this.classList.add(className);
    }

    public void addLoadedClasses(List classList) {
        this.classList.addAll(classList);
    }

    public void setUseExistingCocoon(boolean useExistingCocoon) {
        this.useExistingCocoon = useExistingCocoon;
    }

    public void processURI(String uri, OutputStream outputStream) throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        this.log.info("Processing URI: " + uri);
        TreeMap parameters = new TreeMap();
        TreeMap<String, String> headers = new TreeMap<String, String>();
        String deparameterizedURI = NetUtils.deparameterize(uri, parameters);
        headers.put("user-agent", this.userAgent);
        headers.put("accept", this.accept);
        int status = this.getPage(deparameterizedURI, 0L, parameters, headers, null, null, outputStream);
        if (status >= 400) {
            throw new ProcessingException("Resource not found: " + status);
        }
    }

    public void processURI(String uri, ContentHandler handler) throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        this.log.info("Processing URI: " + uri);
        TreeMap parameters = new TreeMap();
        TreeMap<String, String> headers = new TreeMap<String, String>();
        String deparameterizedURI = NetUtils.deparameterize(uri, parameters);
        headers.put("user-agent", this.userAgent);
        headers.put("accept", this.accept);
        int status = this.getPage(deparameterizedURI, 0L, parameters, headers, null, null, handler);
        if (status >= 400) {
            throw new ProcessingException("Resource not found: " + status);
        }
    }

    public void dispose() {
        if (this.initialized) {
            this.initialized = false;
            ContainerUtil.dispose((Object)this.cocoon);
            this.cocoon = null;
            this.logManager.dispose();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Disposed");
            }
        }
    }

    protected Collection getLinks(String deparameterizedURI, Map parameters) throws Exception {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("user-agent", this.userAgent);
        headers.put("accept", this.accept);
        LinkSamplingEnvironment env = new LinkSamplingEnvironment(deparameterizedURI, this.context, null, parameters, headers, this.cliContext, this.log);
        this.processLenient(env);
        return env.getLinks();
    }

    protected int getPage(String deparameterizedURI, long lastModified, Map parameters, Map headers, Map links, List gatheredLinks, OutputStream stream) throws Exception {
        headers.put("user-agent", this.userAgent);
        headers.put("accept", this.accept);
        FileSavingEnvironment env = new FileSavingEnvironment(deparameterizedURI, lastModified, this.context, null, parameters, headers, links, gatheredLinks, this.cliContext, stream, this.log);
        this.cocoon.process(env);
        int status = env.getStatus();
        if (!env.isModified()) {
            status = -1;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPage(String deparameterizedURI, long lastModified, Map parameters, Map headers, Map links, List gatheredLinks, ContentHandler handler) throws Exception {
        FileSavingEnvironment env = new FileSavingEnvironment(deparameterizedURI, lastModified, this.context, null, parameters, headers, links, gatheredLinks, this.cliContext, null, this.log);
        ContentHandlerWrapper consumer = new ContentHandlerWrapper(handler);
        ProcessingPipeline pipeline = this.cocoon.buildPipeline(env);
        CocoonComponentManager.enterEnvironment(env, (ComponentManager)this.cocoon.getComponentManager(), this.cocoon);
        try {
            pipeline.prepareInternal(env);
            pipeline.process(env, consumer);
        }
        finally {
            CocoonComponentManager.leaveEnvironment();
        }
        int status = env.getStatus();
        if (!env.isModified()) {
            status = -1;
        }
        return status;
    }

    protected String getType(String deparameterizedURI, Map parameters) throws Exception {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("user-agent", this.userAgent);
        headers.put("accept", this.accept);
        FileSavingEnvironment env = new FileSavingEnvironment(deparameterizedURI, this.context, null, parameters, headers, this.empty, null, this.cliContext, new NullOutputStream(), this.log);
        this.processLenient(env);
        return env.getContentType();
    }

    private boolean processLenient(Environment env) throws Exception {
        try {
            this.cocoon.process(env);
        }
        catch (ProcessingException pe) {
            return false;
        }
        return true;
    }

    protected String getClassPath(String context) {
        StringBuffer buildClassPath = new StringBuffer();
        String classDir = context + "/WEB-INF/classes";
        buildClassPath.append(classDir);
        File root = new File(context + "/WEB-INF/lib");
        if (root.isDirectory()) {
            Object[] libraries = root.listFiles();
            Arrays.sort(libraries);
            for (int i = 0; i < libraries.length; ++i) {
                if (!((File)libraries[i]).getAbsolutePath().endsWith(".jar")) continue;
                buildClassPath.append(File.pathSeparatorChar).append(IOUtils.getFullFilename((File)libraries[i]));
            }
        }
        buildClassPath.append(File.pathSeparatorChar).append(SystemUtils.JAVA_CLASS_PATH);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Context classpath: " + buildClassPath);
        }
        return buildClassPath.toString();
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }

    private static class CocoonInstance
    extends CocoonAccess {
        private CocoonInstance() {
        }

        final Cocoon instance() {
            return super.getCocoon();
        }
    }
}

