/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean.helpers;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class DelayedOutputStream
extends OutputStream {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private OutputStream fos = null;

    public void setFileOutputStream(OutputStream outputStream) throws FileNotFoundException {
        if (this.fos == null) {
            this.fos = outputStream;
        }
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream os = this.getTargetOutputStream();
        os.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        OutputStream os = this.getTargetOutputStream();
        os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        OutputStream os = this.getTargetOutputStream();
        os.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IOException ioexception = null;
        this.getTargetOutputStream();
        try {
            if (this.baos != null) {
                this.baos.close();
            }
        }
        catch (IOException ioe) {
            ioexception = ioe;
        }
        finally {
            this.baos = null;
        }
        try {
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (IOException ioe) {
            if (ioexception == null) {
                ioexception = ioe;
            }
        }
        finally {
            this.fos = null;
        }
        if (ioexception != null) {
            throw ioexception;
        }
    }

    @Override
    public void flush() throws IOException {
        IOException ioexception;
        block7: {
            ioexception = null;
            this.getTargetOutputStream();
            try {
                if (this.baos != null) {
                    this.baos.flush();
                }
            }
            catch (IOException ioe) {
                ioexception = ioe;
            }
            try {
                if (this.fos != null) {
                    this.fos.flush();
                }
            }
            catch (IOException ioe) {
                if (ioexception != null) break block7;
                ioexception = ioe;
            }
        }
        if (ioexception != null) {
            throw ioexception;
        }
    }

    private OutputStream getTargetOutputStream() throws IOException {
        if (this.baos != null && this.fos == null) {
            return this.baos;
        }
        if (this.baos != null && this.fos != null) {
            try {
                this.baos.flush();
                this.baos.writeTo(this.fos);
                this.baos.close();
            }
            finally {
                this.baos = null;
            }
            return this.fos;
        }
        if (this.baos == null && this.fos != null) {
            return this.fos;
        }
        throw new IOException("No outputstream available!");
    }

    public int size() {
        if (this.baos != null) {
            return this.baos.size();
        }
        return 0;
    }

    public byte[] getContent() {
        if (this.baos != null) {
            return this.baos.toByteArray();
        }
        return null;
    }
}

