/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.commons.lang.time.FastDateFormat;

public class WebContinuationDataBean {
    private static final String TYPE_JAVAFLOW = "javaflow";
    private static final String TYPE_FLOWSCRIPT = "flowscript";
    private static final String HAS_EXPIRED_NO = "no";
    private static final String HAS_EXPIRED_YES = "yes";
    private WebContinuation wc;
    private Format formatter = FastDateFormat.getInstance((String)"HH:mm:ss");
    private List _children = new ArrayList();

    public WebContinuationDataBean(WebContinuation wc) {
        this.wc = wc;
        Iterator it = wc.getChildren().iterator();
        while (it.hasNext()) {
            WebContinuationDataBean child = new WebContinuationDataBean((WebContinuation)it.next());
            this._children.add(child);
        }
    }

    public String getId() {
        return this.wc.getId();
    }

    public String getLastAccessTime() {
        return this.formatter.format(new Date(this.wc.getLastAccessTime()));
    }

    public String getInterpreterId() {
        return this.wc.getInterpreterId();
    }

    public String getTimeToLiveInMinutes() {
        return Long.toString(this.wc.getTimeToLive() / 1000L / 60L);
    }

    public String getTimeToLive() {
        return Long.toString(this.wc.getTimeToLive());
    }

    public String getExpireTime() {
        return this.formatter.format(new Date(this.wc.getLastAccessTime() + this.wc.getTimeToLive()));
    }

    public String hasExpired() {
        if (this.wc.hasExpired()) {
            return HAS_EXPIRED_YES;
        }
        return HAS_EXPIRED_NO;
    }

    public String getType() {
        if (this.wc.getUserObject().getClass().getName().indexOf("FOM_WebContinuation") > -1) {
            return TYPE_FLOWSCRIPT;
        }
        return TYPE_JAVAFLOW;
    }

    public List get_children() {
        return this._children;
    }
}

