/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.http.HttpCookie;
import org.apache.regexp.RE;

public class CookieModule
extends AbstractInputModule
implements ThreadSafe {
    @Override
    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        String value;
        HttpCookie cookie = (HttpCookie)this.getCookieMap(objectModel).get(name);
        String string = value = cookie == null ? null : cookie.getValue();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Cookie[" + name + "]=" + value);
        }
        return value;
    }

    @Override
    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.getCookieMap(objectModel).keySet().iterator();
    }

    @Override
    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Map allCookies = this.getCookieMap(objectModel);
        Iterator it = allCookies.values().iterator();
        LinkedList<String> matched = new LinkedList<String>();
        RE regexp = new RE(name);
        while (it.hasNext()) {
            HttpCookie cookie = (HttpCookie)it.next();
            if (!regexp.match(cookie.getName())) continue;
            matched.add(cookie.getValue());
        }
        return matched.toArray();
    }

    protected Map getCookieMap(Map objectModel) {
        return ObjectModelHelper.getRequest(objectModel).getCookieMap();
    }
}

