/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.components.modules.input.IteratorHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;

public class RequestParameterModule
extends AbstractInputModule
implements ThreadSafe {
    @Override
    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        String pname = (String)this.settings.get("parameter", name);
        if (modeConf != null) {
            pname = modeConf.getAttribute("parameter", pname);
            pname = modeConf.getChild("parameter").getValue(pname);
        }
        return ObjectModelHelper.getRequest(objectModel).getParameter(pname);
    }

    @Override
    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return new IteratorHelper(ObjectModelHelper.getRequest(objectModel).getParameterNames());
    }

    @Override
    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        int wildcardIndex;
        Request request = ObjectModelHelper.getRequest(objectModel);
        String wildcard = (String)this.settings.get("parameter", name);
        if (modeConf != null) {
            wildcard = modeConf.getAttribute("parameter", wildcard);
            wildcard = modeConf.getChild("parameter").getValue(wildcard);
        }
        if ((wildcardIndex = wildcard.indexOf("*")) != -1) {
            String prefix = wildcard.substring(0, wildcardIndex);
            String suffix = wildcard.length() >= wildcardIndex + 1 ? wildcard.substring(wildcardIndex + 1) : "";
            TreeSet<String> names = new TreeSet<String>();
            Enumeration allNames = request.getParameterNames();
            while (allNames.hasMoreElements()) {
                String pname = (String)allNames.nextElement();
                if (!pname.startsWith(prefix) || !pname.endsWith(suffix)) continue;
                names.add(pname);
            }
            LinkedList<String> values = new LinkedList<String>();
            for (String pname : names) {
                values.add(request.getParameter(pname));
            }
            return values.toArray();
        }
        return request.getParameterValues(wildcard);
    }
}

