/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.notification;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.cocoon.Constants;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Notifier {
    public static void notify(Notifying n, OutputStream outputStream, String mimetype) throws IOException {
        Notifier.notifyHTML(n, outputStream);
    }

    private static void notifyHTML(Notifying n, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><title>").append(n.getTitle()).append("</title>");
        sb.append("<style><!--");
        sb.append("body { background-color: white; color: black; font-family: verdana, helvetica, sanf serif;}");
        sb.append("h1 {color: #336699; margin: 0px 0px 20px 0px; border-width: 0px 0px 1px 0px; border-style: solid; border-color: #336699;}");
        sb.append("p.footer { color: #336699; border-width: 1px 0px 0px 0px; border-style: solid; border-color: #336699; }");
        sb.append("span {color: #336699;}");
        sb.append("pre {padding-left: 20px;}");
        sb.append("a:link {font-weight: bold; color: #336699;}");
        sb.append("a:visited {color: #336699; }");
        sb.append("a:hover {color: #800000; background-color: #ffff80;}");
        sb.append("a:active {color: #006666;}");
        sb.append("--></style>");
        sb.append("</head><body>");
        sb.append("<h1>").append(StringEscapeUtils.escapeXml((String)n.getTitle())).append("</h1>");
        sb.append("<p><span>Message:</span> ").append(StringEscapeUtils.escapeXml((String)n.getMessage())).append("</p>");
        sb.append("<p><span>Description:</span> ").append(StringEscapeUtils.escapeXml((String)n.getDescription())).append("</p>");
        sb.append("<p><span>Sender:</span> ").append(StringEscapeUtils.escapeXml((String)n.getSender())).append("</p>");
        sb.append("<p><span>Source:</span> ").append(StringEscapeUtils.escapeXml((String)n.getSource())).append("</p>");
        Map extras = n.getExtraDescriptions();
        for (Map.Entry me : extras.entrySet()) {
            String key = (String)me.getKey();
            sb.append("<p><span>").append(key).append("</span><pre>").append(StringEscapeUtils.escapeXml((String)String.valueOf(me.getValue()))).append("</pre></p>");
        }
        sb.append("<p class='footer'><a href='http://cocoon.apache.org/'>").append(Constants.COMPLETE_NAME).append("</p>");
        sb.append("</body></html>");
        outputStream.write(sb.toString().getBytes());
    }

    public static void notify(Notifying n, ContentHandler ch, String mimetype) throws SAXException {
        String PREFIX = "error";
        String URI2 = "http://apache.org/cocoon/error/2.1";
        ch.startDocument();
        ch.startPrefixMapping("error", "http://apache.org/cocoon/error/2.1");
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("http://apache.org/cocoon/error/2.1", "type", "error:type", "CDATA", n.getType());
        atts.addAttribute("http://apache.org/cocoon/error/2.1", "sender", "error:sender", "CDATA", n.getSender());
        ch.startElement("http://apache.org/cocoon/error/2.1", "notify", "error:notify", atts);
        ch.startElement("http://apache.org/cocoon/error/2.1", "title", "error:title", new AttributesImpl());
        ch.characters(n.getTitle().toCharArray(), 0, n.getTitle().length());
        ch.endElement("http://apache.org/cocoon/error/2.1", "title", "error:title");
        ch.startElement("http://apache.org/cocoon/error/2.1", "source", "error:source", new AttributesImpl());
        ch.characters(n.getSource().toCharArray(), 0, n.getSource().length());
        ch.endElement("http://apache.org/cocoon/error/2.1", "source", "error:source");
        ch.startElement("http://apache.org/cocoon/error/2.1", "message", "error:message", new AttributesImpl());
        if (n.getMessage() != null) {
            ch.characters(n.getMessage().toCharArray(), 0, n.getMessage().length());
        }
        ch.endElement("http://apache.org/cocoon/error/2.1", "message", "error:message");
        ch.startElement("http://apache.org/cocoon/error/2.1", "description", "error:description", XMLUtils.EMPTY_ATTRIBUTES);
        ch.characters(n.getDescription().toCharArray(), 0, n.getDescription().length());
        ch.endElement("http://apache.org/cocoon/error/2.1", "description", "error:description");
        Map extraDescriptions = n.getExtraDescriptions();
        for (Map.Entry me : extraDescriptions.entrySet()) {
            String key = (String)me.getKey();
            String value = String.valueOf(me.getValue());
            atts = new AttributesImpl();
            atts.addAttribute("http://apache.org/cocoon/error/2.1", "description", "error:description", "CDATA", key);
            ch.startElement("http://apache.org/cocoon/error/2.1", "extra", "error:extra", atts);
            ch.characters(value.toCharArray(), 0, value.length());
            ch.endElement("http://apache.org/cocoon/error/2.1", "extra", "error:extra");
        }
        ch.endElement("http://apache.org/cocoon/error/2.1", "notify", "error:notify");
        ch.endPrefixMapping("error");
        ch.endDocument();
    }
}

