/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.Processor;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class SitemapSource
extends AbstractLogEnabled
implements Source,
XMLizable {
    private SitemapSourceValidity validity;
    private final String systemId;
    private String systemIdForCaching;
    private final ComponentManager manager;
    private final Processor processor;
    private Processor pipelineProcessor;
    private final MutableEnvironmentFacade environment;
    private ProcessingPipeline processingPipeline;
    private Source redirectSource;
    private SAXException exception;
    private boolean needsRefresh;
    private Object processKey;
    private final String protocol;
    private SourceResolver sourceResolver;
    private String mimeType;

    public SitemapSource(ComponentManager manager, String uri, Map parameters, Logger logger) throws MalformedURLException {
        String tmp;
        int index;
        String prefix;
        Environment env = CocoonComponentManager.getCurrentEnvironment();
        if (env == null) {
            throw new MalformedURLException("The cocoon protocol can not be used outside an environment.");
        }
        this.manager = manager;
        this.enableLogging(logger);
        boolean rawMode = false;
        int position = uri.indexOf(58) + 1;
        if (position != 0) {
            this.protocol = uri.substring(0, position - 1);
            if (uri.startsWith("raw:", position)) {
                position += 4;
                rawMode = true;
            }
        } else {
            throw new MalformedURLException("No protocol found for sitemap source in " + uri);
        }
        if (uri.startsWith("//", position)) {
            position += 2;
            this.processor = CocoonComponentManager.getActiveProcessor(env).getRootProcessor();
            prefix = "";
        } else if (uri.startsWith("/", position)) {
            ++position;
            prefix = null;
            this.processor = CocoonComponentManager.getActiveProcessor(env);
        } else {
            throw new MalformedURLException("Malformed cocoon URI: " + uri);
        }
        String queryString = null;
        int queryStringPos = uri.indexOf(63, position);
        if (queryStringPos != -1) {
            queryString = uri.substring(queryStringPos + 1);
            uri = uri.substring(position, queryStringPos);
        } else if (position > 0) {
            uri = uri.substring(position);
        }
        String view = null;
        view = queryString != null ? ((index = queryString.indexOf("cocoon-view")) != -1 && (index == 0 || queryString.charAt(index - 1) == '&') && queryString.length() > index + "cocoon-view".length() && queryString.charAt(index + "cocoon-view".length()) == '=' ? ((index = (tmp = queryString.substring(index + "cocoon-view".length() + 1)).indexOf(38)) != -1 ? tmp.substring(0, index) : tmp) : env.getView()) : env.getView();
        String requestURI = prefix == null ? env.getURIPrefix() + uri : uri;
        this.systemId = queryString == null ? this.protocol + "://" + requestURI : this.protocol + "://" + requestURI + "?" + queryString;
        EnvironmentWrapper wrapper = new EnvironmentWrapper(env, requestURI, queryString, logger, manager, rawMode, view);
        wrapper.setURI(prefix, uri);
        this.environment = new MutableEnvironmentFacade(wrapper);
        if (null != parameters) {
            this.environment.getObjectModel().put("parent-context", parameters);
        } else {
            this.environment.getObjectModel().remove("parent-context");
        }
        this.validity = new SitemapSourceValidity();
        this.init();
    }

    public String getScheme() {
        return this.protocol;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.exception != null) {
            throw new SourceException("Cannot get input stream for " + this.getURI(), (Throwable)this.exception);
        }
        if (this.redirectSource != null) {
            return this.redirectSource.getInputStream();
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.environment.setOutputStream(os);
            CocoonComponentManager.enterEnvironment(this.environment, this.manager, this.pipelineProcessor);
            try {
                this.processingPipeline.process(this.environment);
            }
            finally {
                CocoonComponentManager.leaveEnvironment();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
        catch (ResourceNotFoundException e) {
            throw new SourceNotFoundException("Exception during processing of " + this.systemId, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new SourceException("Exception during processing of " + this.systemId, (Throwable)e);
        }
        finally {
            this.environment.setOutputStream(null);
            this.needsRefresh = true;
        }
    }

    public String getURI() {
        return this.systemIdForCaching;
    }

    public boolean exists() {
        return true;
    }

    public SourceValidity getValidity() {
        return this.validity.getNestedValidity() == null ? null : this.validity;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void refresh() {
        this.reset();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        block13: {
            this.systemIdForCaching = this.systemId;
            try {
                this.processKey = CocoonComponentManager.startProcessing(this.environment);
                this.processingPipeline = this.processor.buildPipeline(this.environment);
                this.pipelineProcessor = CocoonComponentManager.getActiveProcessor(this.environment);
                String redirectURL = this.environment.getRedirectURL();
                if (redirectURL == null) {
                    CocoonComponentManager.enterEnvironment(this.environment, this.manager, this.pipelineProcessor);
                    try {
                        this.processingPipeline.prepareInternal(this.environment);
                        this.validity.set(this.processingPipeline.getValidityForEventPipeline());
                        this.mimeType = this.environment.getContentType();
                        String eventPipelineKey = this.processingPipeline.getKeyForEventPipeline();
                        if (eventPipelineKey != null) {
                            StringBuffer buffer = new StringBuffer(this.systemId);
                            if (this.systemId.indexOf(63) == -1) {
                                buffer.append('?');
                            } else {
                                buffer.append('&');
                            }
                            buffer.append("pipelinehash=");
                            buffer.append(eventPipelineKey);
                            this.systemIdForCaching = buffer.toString();
                        } else {
                            this.systemIdForCaching = this.systemId;
                        }
                        break block13;
                    }
                    finally {
                        CocoonComponentManager.leaveEnvironment();
                    }
                }
                if (redirectURL.indexOf(":") == -1) {
                    redirectURL = this.protocol + ":/" + redirectURL;
                }
                if (this.sourceResolver == null) {
                    this.sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                }
                this.redirectSource = this.sourceResolver.resolveURI(redirectURL);
                this.validity.set(this.redirectSource.getValidity());
                this.mimeType = this.redirectSource.getMimeType();
            }
            catch (SAXException e) {
                this.reset();
                this.exception = e;
            }
            catch (Exception e) {
                this.reset();
                this.exception = new SAXException("Could not get sitemap source " + this.systemId, e);
            }
        }
        this.needsRefresh = false;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        block12: {
            if (this.needsRefresh) {
                this.refresh();
            }
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                if (this.redirectSource != null) {
                    SourceUtil.parse(this.manager, this.redirectSource, contentHandler);
                    break block12;
                }
                XMLConsumer consumer = contentHandler instanceof XMLConsumer ? (XMLConsumer)((Object)contentHandler) : (contentHandler instanceof LexicalHandler ? new ContentHandlerWrapper(contentHandler, (LexicalHandler)((Object)contentHandler)) : new ContentHandlerWrapper(contentHandler));
                CocoonComponentManager.enterEnvironment(this.environment, this.manager, this.pipelineProcessor);
                try {
                    this.processingPipeline.process(this.environment, CocoonComponentManager.createEnvironmentAwareConsumer(consumer));
                }
                finally {
                    CocoonComponentManager.leaveEnvironment();
                }
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException("Exception during processing of " + this.systemId, e);
            }
            finally {
                this.needsRefresh = true;
            }
        }
    }

    private void reset() {
        if (this.processingPipeline != null) {
            this.processingPipeline.release();
            this.processingPipeline = null;
        }
        if (this.processKey != null) {
            CocoonComponentManager.endProcessing(this.environment, this.processKey);
            this.processKey = null;
        }
        if (this.redirectSource != null) {
            this.sourceResolver.release(this.redirectSource);
            this.redirectSource = null;
        }
        this.validity.set(null);
        this.environment.reset();
        this.exception = null;
        this.needsRefresh = true;
        this.pipelineProcessor = null;
    }

    public void recycle() {
        this.validity = new SitemapSourceValidity();
        this.reset();
        if (this.sourceResolver != null) {
            this.manager.release((Component)this.sourceResolver);
            this.sourceResolver = null;
        }
    }

    public String getParameter(String name) {
        return null;
    }

    public long getParameterAsLong(String name) {
        return 0L;
    }

    public Iterator getParameterNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    public static final class SitemapSourceValidity
    implements SourceValidity,
    Serializable {
        private SourceValidity validity;

        private SitemapSourceValidity() {
        }

        void set(SourceValidity validity) {
            this.validity = validity;
        }

        public int isValid() {
            return this.validity != null ? this.validity.isValid() : -1;
        }

        public int isValid(SourceValidity validity) {
            if (validity instanceof SitemapSourceValidity) {
                return this.validity != null ? this.validity.isValid(((SitemapSourceValidity)validity).getNestedValidity()) : -1;
            }
            return -1;
        }

        public SourceValidity getNestedValidity() {
            return this.validity;
        }
    }
}

