/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.util.MIMEUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;

public class ZipSource
extends AbstractLogEnabled
implements Source {
    private String protocol;
    private Source archive;
    private String filePath;

    public ZipSource(String protocol, Source archive, String filePath) {
        this.protocol = protocol;
        this.archive = archive;
        this.filePath = filePath;
    }

    private ZipEntry findEntry(ZipInputStream zipStream) throws IOException {
        ZipEntry entry;
        while ((entry = zipStream.getNextEntry()) != null) {
            if (entry.getName().equals(this.filePath)) {
                return entry;
            }
            zipStream.closeEntry();
        }
        return null;
    }

    void dispose(SourceResolver resolver) {
        resolver.release(this.archive);
        this.archive = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        if (!this.archive.exists()) {
            return false;
        }
        ZipInputStream zipStream = null;
        try {
            zipStream = new ZipInputStream(this.archive.getInputStream());
            boolean bl = this.findEntry(zipStream) != null;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipStream != null) {
                    zipStream.close();
                }
            }
            catch (IOException e) {
                this.getLogger().error("IOException while closing ZipInputStream: " + this.filePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        ZipInputStream zipStream = new ZipInputStream(this.archive.getInputStream());
        try {
            ZipEntry entry = this.findEntry(zipStream);
            if (entry == null) {
                throw new SourceNotFoundException("File " + this.filePath + " is not found in the archive " + this.archive.getURI());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while (zipStream.available() > 0) {
                int length = zipStream.read(buffer, 0, 8192);
                if (length <= 0) continue;
                baos.write(buffer, 0, length);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException e) {
                this.getLogger().error("IOException while closing ZipInputStream: " + this.filePath);
            }
        }
    }

    public String getURI() {
        return this.protocol + ":" + this.archive.getURI() + "!/" + this.filePath;
    }

    public String getScheme() {
        return this.protocol;
    }

    public SourceValidity getValidity() {
        return this.archive.getValidity();
    }

    public void refresh() {
    }

    public String getMimeType() {
        String ext = this.filePath.substring(this.filePath.lastIndexOf("."));
        return MIMEUtils.getMIMEType(ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength() {
        ZipInputStream zipStream = null;
        try {
            zipStream = new ZipInputStream(this.archive.getInputStream());
            ZipEntry entry = this.findEntry(zipStream);
            if (entry != null) {
                long l = entry.getSize();
                return l;
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (zipStream != null) {
                    zipStream.close();
                }
            }
            catch (IOException e) {
                this.getLogger().error("IOException while closing ZipInputStream: " + this.filePath);
            }
        }
        return -1L;
    }

    public long getLastModified() {
        return this.archive.getLastModified();
    }
}

