/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.NamedProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleSelectorProcessingNode;
import org.apache.cocoon.environment.Environment;

public class ActionSetNode
extends SimpleSelectorProcessingNode
implements NamedProcessingNode {
    public static final String CALLER_PARAMETERS = ActionSetNode.class.getName() + "/CallerParameters";
    public static final String ACTION_RESULTS = ActionSetNode.class.getName() + "/ActionResults";
    private ProcessingNode[] nodes;
    private String[] actionNames;

    public ActionSetNode(String name, ProcessingNode[] nodes, String[] actionNames) {
        super(name);
        this.nodes = nodes;
        this.actionNames = actionNames;
    }

    @Override
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        String msg = "An action-set cannot be invoked, at " + this.getLocation();
        throw new UnsupportedOperationException(msg);
    }

    public final Map call(Environment env, InvokeContext context, Parameters params) throws Exception {
        String cocoonAction = env.getAction();
        HashMap result = null;
        env.setAttribute(CALLER_PARAMETERS, params);
        for (int i = 0; i < this.nodes.length; ++i) {
            String actionName = this.actionNames[i];
            if (actionName != null && !actionName.equals(cocoonAction)) continue;
            this.nodes[i].invoke(env, context);
            Map actionResult = (Map)env.getAttribute(ACTION_RESULTS);
            env.removeAttribute(ACTION_RESULTS);
            if (actionResult == null) continue;
            if (result == null) {
                result = new HashMap(actionResult);
                continue;
            }
            result.putAll(actionResult);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.componentName;
    }
}

