/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.environment.Environment;
import org.apache.commons.lang.SystemUtils;

public final class HandleErrorsNode
extends AbstractParentProcessingNode {
    private ProcessingNode[] children;
    private int statusCode;
    private boolean internal;
    private boolean external;

    public HandleErrorsNode(int statusCode, String scope) throws ConfigurationException {
        this.statusCode = statusCode;
        if ("internal".equals(scope)) {
            this.internal = true;
        } else if ("external".equals(scope)) {
            this.external = true;
        } else if ("always".equals(scope)) {
            this.internal = true;
            this.external = true;
        } else {
            throw new ConfigurationException("Unrecognized value of when attribute on <handle-errors> at " + this.getLocation());
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setChildren(ProcessingNode[] nodes) {
        this.children = nodes;
    }

    @Override
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Processing handle-errors at " + this.getLocation());
        }
        if (this.statusCode == -1) {
            try {
                return this.invokeNodes(this.children, env, context);
            }
            catch (ProcessingException e) {
                if (e.getMessage().indexOf("Must set a generator before adding") != -1) {
                    env.getObjectModel().remove("notifying-object");
                    throw new ProcessingException("Incomplete pipeline: 'handle-error' without a 'type' must include a generator, at " + this.getLocation() + SystemUtils.LINE_SEPARATOR + "Either add a generator (preferred) or a type='500' attribute (deprecated) on 'handle-errors'");
                }
                throw e;
            }
        }
        context.getProcessingPipeline().setGenerator("<notifier>", "", Parameters.EMPTY_PARAMETERS, Parameters.EMPTY_PARAMETERS);
        try {
            return this.invokeNodes(this.children, env, context);
        }
        catch (ProcessingException e) {
            if (e.getMessage().indexOf("Generator already set") != -1) {
                env.getObjectModel().remove("notifying-object");
                throw new ProcessingException("Error: 'handle-error' with a 'type' attribute has an implicit generator, at " + this.getLocation() + SystemUtils.LINE_SEPARATOR + "Please remove the 'type' attribute on 'handle-error'");
            }
            throw e;
        }
    }
}

