/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ErrorHandlerHelper;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.SitemapErrorHandler;

public class PipelineNode
extends AbstractParentProcessingNode
implements Composable,
ParameterizableProcessingNode {
    private ProcessingNode[] children;
    private ErrorHandlerHelper errorHandlerHelper;
    private boolean internalOnly;
    private boolean isLast;
    protected String processingPipeline;
    protected Map parameters;

    public PipelineNode(String name) {
        this.processingPipeline = name;
        this.errorHandlerHelper = new ErrorHandlerHelper();
    }

    public void compose(ComponentManager manager) {
        this.errorHandlerHelper.compose(manager);
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.errorHandlerHelper.enableLogging(logger);
    }

    public void setChildren(ProcessingNode[] nodes) {
        this.children = nodes;
    }

    @Override
    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    public void set404Handler(ProcessingNode node) {
        this.errorHandlerHelper.set404Handler(node);
    }

    public void set500Handler(ProcessingNode node) {
        this.errorHandlerHelper.set500Handler(node);
    }

    public void setInternalOnly(boolean internalOnly) {
        this.internalOnly = internalOnly;
    }

    @Override
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Object passThroughRaw = env.getAttribute("COCOON_PASS_THROUGH");
        boolean passThrough = passThroughRaw == null ? false : (Boolean)passThroughRaw;
        if (this.internalOnly && env.isExternal()) {
            if (!this.isLast || passThrough) {
                return false;
            }
            throw new ResourceNotFoundException("No pipeline matched request: " + env.getURIPrefix() + env.getURI());
        }
        context.inform(this.processingPipeline, this.parameters, env.getObjectModel());
        try {
            if (this.errorHandlerHelper.isInternal()) {
                context.setErrorHandler(new SitemapErrorHandler(this.errorHandlerHelper, env, context));
            } else {
                context.setErrorHandler(null);
            }
            if (this.invokeNodes(this.children, env, context)) {
                return true;
            }
            if (!this.isLast || passThrough) {
                return false;
            }
            throw new ResourceNotFoundException("No pipeline matched request: " + env.getURIPrefix() + env.getURI());
        }
        catch (ConnectionResetException e) {
            throw e;
        }
        catch (Exception e) {
            return this.errorHandlerHelper.invokeErrorHandler(e, env, context);
        }
    }
}

