/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.environment.commandline.AbstractCommandLineEnvironment;
import org.apache.cocoon.environment.commandline.CommandLineContext;

public class LinkSamplingEnvironment
extends AbstractCommandLineEnvironment {
    private boolean skip = false;

    public LinkSamplingEnvironment(String uri, File contextFile, Map attributes, Map parameters, Map headers, CommandLineContext cliContext, Logger log) throws MalformedURLException, IOException {
        super(uri, attributes, parameters, headers, "links", contextFile, cliContext, new ByteArrayOutputStream(), log);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("uri = " + uri);
        }
    }

    @Override
    public void setContentType(String contentType) {
        if (!"application/x-cocoon-links".equals(contentType)) {
            this.skip = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getLinks() throws IOException {
        HashSet<String> set = new HashSet<String>();
        if (!this.skip) {
            BufferedReader buffer = null;
            try {
                String line;
                buffer = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(((ByteArrayOutputStream)this.outputStream).toByteArray())));
                while ((line = buffer.readLine()) != null) {
                    set.add(line);
                }
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                        buffer = null;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return set;
    }
}

