/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.http.HttpCookie;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.cocoon.environment.http.HttpSession;
import org.apache.cocoon.servlet.multipart.MultipartHttpServletRequest;

public final class HttpRequest
implements Request {
    private final HttpServletRequest req;
    private final HttpEnvironment env;
    private String form_encoding;
    private String container_encoding;
    private static final Map sessions = new WeakHashMap();
    private Cookie[] wrappedCookies = null;
    private Map wrappedCookieMap = null;
    protected String reqURI;

    protected HttpRequest(HttpServletRequest req, HttpEnvironment env) {
        this.req = req;
        this.env = env;
    }

    @Override
    public Object get(String name) {
        if (this.req instanceof MultipartHttpServletRequest) {
            return ((MultipartHttpServletRequest)this.req).get(name);
        }
        String[] values = this.req.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        if (values.length > 1) {
            Vector<String> vect = new Vector<String>(values.length);
            for (int i = 0; i < values.length; ++i) {
                vect.add(values[i]);
            }
            return vect;
        }
        return null;
    }

    @Override
    public String getAuthType() {
        return this.req.getAuthType();
    }

    @Override
    public Cookie[] getCookies() {
        if (this.wrappedCookieMap == null) {
            this.wrapCookies();
        }
        return this.wrappedCookies;
    }

    @Override
    public Map getCookieMap() {
        if (this.wrappedCookieMap == null) {
            this.wrapCookies();
        }
        return this.wrappedCookieMap;
    }

    private synchronized void wrapCookies() {
        this.wrappedCookieMap = new HashMap();
        javax.servlet.http.Cookie[] cookies = this.req.getCookies();
        if (cookies != null) {
            this.wrappedCookies = new Cookie[cookies.length];
            for (int i = 0; i < cookies.length; ++i) {
                HttpCookie cookie = new HttpCookie(cookies[i]);
                this.wrappedCookies[i] = cookie;
                this.wrappedCookieMap.put(cookie.getName(), cookie);
            }
        }
        this.wrappedCookieMap = Collections.unmodifiableMap(this.wrappedCookieMap);
    }

    @Override
    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    @Override
    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    @Override
    public Enumeration getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    @Override
    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.req.getIntHeader(name);
    }

    @Override
    public String getMethod() {
        return this.req.getMethod();
    }

    @Override
    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    @Override
    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    @Override
    public String getContextPath() {
        return this.req.getContextPath();
    }

    @Override
    public String getQueryString() {
        return this.req.getQueryString();
    }

    @Override
    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    @Override
    public String getRequestedSessionId() {
        return this.req.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        if (this.reqURI == null) {
            this.reqURI = this.req.getRequestURI();
            if (this.reqURI.equals("/")) {
                String s = this.req.getServletPath();
                StringBuffer buffer = new StringBuffer();
                if (null != s) {
                    buffer.append(s);
                }
                if (null != (s = this.req.getPathInfo())) {
                    buffer.append(s);
                }
                this.reqURI = buffer.toString();
            }
        }
        return this.reqURI;
    }

    @Override
    public String getSitemapURI() {
        return this.env.getURI();
    }

    @Override
    public String getSitemapURIPrefix() {
        return this.env.getURIPrefix();
    }

    @Override
    public String getServletPath() {
        return this.req.getServletPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(boolean create) {
        HttpSession session;
        javax.servlet.http.HttpSession serverSession = this.req.getSession(create);
        if (serverSession != null) {
            Map map = sessions;
            synchronized (map) {
                WeakReference ref = (WeakReference)sessions.get(serverSession);
                if (ref == null || (session = (HttpSession)ref.get()) == null) {
                    session = new HttpSession(serverSession);
                    sessions.put(serverSession, new WeakReference<HttpSession>(session));
                }
            }
        } else {
            session = null;
        }
        return session;
    }

    @Override
    public Session getSession() {
        return this.getSession(true);
    }

    @Override
    public Session getCocoonSession(boolean create) {
        return this.getSession(create);
    }

    @Override
    public Session getCocoonSession() {
        return this.getSession(true);
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromURL();
    }

    @Override
    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return this.req.getAttributeNames();
    }

    @Override
    public String getCharacterEncoding() {
        if (this.form_encoding == null) {
            return this.req.getCharacterEncoding();
        }
        return this.form_encoding;
    }

    @Override
    public void setCharacterEncoding(String form_encoding) throws UnsupportedEncodingException {
        this.form_encoding = form_encoding;
    }

    public void setContainerEncoding(String container_encoding) {
        this.container_encoding = container_encoding;
    }

    @Override
    public int getContentLength() {
        return this.req.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.req.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    @Override
    public String getParameter(String name) {
        String value = this.req.getParameter(name);
        if (!this.container_encoding.equals(this.form_encoding)) {
            value = this.decode(value);
        }
        return value;
    }

    private String decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            byte[] bytes = str.getBytes(this.container_encoding);
            return new String(bytes, this.form_encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new CascadingRuntimeException("Unsupported Encoding Exception", (Throwable)uee);
        }
    }

    @Override
    public Enumeration getParameterNames() {
        return this.req.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        String[] values = this.req.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (this.container_encoding.equals(this.form_encoding)) {
            return values;
        }
        String[] decoded_values = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            decoded_values[i] = this.decode(values[i]);
        }
        return decoded_values;
    }

    @Override
    public String getProtocol() {
        return this.req.getProtocol();
    }

    @Override
    public String getScheme() {
        return this.req.getScheme();
    }

    @Override
    public String getServerName() {
        return this.req.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.req.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.req.getReader();
    }

    @Override
    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }

    @Override
    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    @Override
    public Locale getLocale() {
        return this.req.getLocale();
    }

    @Override
    public Enumeration getLocales() {
        return this.req.getLocales();
    }

    @Override
    public boolean isSecure() {
        return this.req.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.req.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.req.getRealPath(path);
    }
}

