/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.http.HttpCookie;

public final class HttpResponse
implements Response {
    private final HttpServletResponse res;

    protected HttpResponse(HttpServletResponse res) {
        this.res = res;
    }

    @Override
    public Cookie createCookie(String name, String value) {
        return new HttpCookie(name, value);
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (cookie instanceof HttpCookie) {
            this.res.addCookie(((HttpCookie)cookie).getServletCookie());
        } else {
            javax.servlet.http.Cookie newCookie = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
            newCookie.setComment(cookie.getComment());
            newCookie.setDomain(cookie.getDomain());
            newCookie.setMaxAge(cookie.getMaxAge());
            newCookie.setPath(cookie.getPath());
            newCookie.setSecure(cookie.getSecure());
            newCookie.setVersion(cookie.getVersion());
            this.res.addCookie(newCookie);
        }
    }

    @Override
    public boolean containsHeader(String name) {
        return this.res.containsHeader(name);
    }

    @Override
    public String encodeURL(String url) {
        if (url != null && url.indexOf(";jsessionid=") != -1) {
            return url;
        }
        return this.res.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        if (url != null && url.indexOf(";jsessionid=") != -1) {
            return url;
        }
        return this.res.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.res.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.res.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.res.sendRedirect(location);
    }

    public void sendPermanentRedirect(String location) throws IOException {
        this.res.setHeader("location", location);
        this.res.setStatus(301);
    }

    @Override
    public void setDateHeader(String name, long date) {
        this.res.setDateHeader(name, date);
    }

    @Override
    public void addDateHeader(String name, long date) {
        this.res.addDateHeader(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        this.res.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.res.addHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.res.setIntHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.res.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        this.res.setStatus(sc);
    }

    public String encodeUrl(String url) {
        return this.res.encodeUrl(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.res.encodeRedirectUrl(url);
    }

    public void setStatus(int sc, String sm) {
        this.res.setStatus(sc, sm);
    }

    @Override
    public String getCharacterEncoding() {
        return this.res.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.res.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.res.getWriter();
    }

    public void setContentLength(int len) {
        this.res.setContentLength(len);
    }

    public void setContentType(String type) {
        this.res.setContentType(type);
    }

    public void setBufferSize(int size) {
        this.res.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.res.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.res.flushBuffer();
    }

    public boolean isCommitted() {
        return this.res.isCommitted();
    }

    public void reset() {
        this.res.reset();
    }

    @Override
    public void setLocale(Locale loc) {
        this.res.setLocale(loc);
    }

    @Override
    public Locale getLocale() {
        return this.res.getLocale();
    }
}

