/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.util.location.LocatableException;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.cocoon.util.location.MultiLocatable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExceptionGenerator
extends AbstractGenerator {
    private Throwable thr;
    public static final String EXCEPTION_NS = "http://apache.org/cocoon/exception/1.0";

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.thr = (Throwable)objectModel.get("throwable");
        if (this.thr == null) {
            throw new ProcessingException("ExceptionGenerator should be used in <map:handle-errors>");
        }
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        ExceptionGenerator.toSAX(this.thr, this.contentHandler);
        this.contentHandler.endDocument();
    }

    public static void toSAX(Throwable thr, ContentHandler handler) throws SAXException {
        Throwable root = ExceptionUtils.getRootCause((Throwable)thr);
        if (root == null) {
            root = thr;
        }
        AttributesImpl attr = new AttributesImpl();
        handler.startPrefixMapping("ex", EXCEPTION_NS);
        attr.addCDATAAttribute("class", root.getClass().getName());
        handler.startElement(EXCEPTION_NS, "exception-report", "ex:exception-report", attr);
        Location loc = LocationUtils.getLocation(root);
        if (LocationUtils.isKnown(loc)) {
            attr.clear();
            ExceptionGenerator.dumpLocation(loc, attr, handler);
        }
        attr.clear();
        String message = root instanceof LocatableException ? ((LocatableException)((Object)root)).getRawMessage() : root.getMessage();
        ExceptionGenerator.simpleElement("message", attr, message, handler);
        handler.startElement(EXCEPTION_NS, "cocoon-stacktrace", "ex:cocoon-stacktrace", attr);
        Throwable current = thr;
        while (current != null) {
            loc = LocationUtils.getLocation(current);
            if (LocationUtils.isKnown(loc)) {
                handler.startElement(EXCEPTION_NS, "exception", "ex:exception", attr);
                message = current instanceof LocatableException ? ((LocatableException)((Object)current)).getRawMessage() : current.getMessage();
                ExceptionGenerator.simpleElement("message", attr, message, handler);
                attr.clear();
                handler.startElement(EXCEPTION_NS, "locations", "ex:locations", attr);
                ExceptionGenerator.dumpLocation(loc, attr, handler);
                if (current instanceof MultiLocatable) {
                    List locations = ((MultiLocatable)((Object)current)).getLocations();
                    for (int i = 1; i < locations.size(); ++i) {
                        attr.clear();
                        ExceptionGenerator.dumpLocation((Location)locations.get(i), attr, handler);
                    }
                }
                handler.endElement(EXCEPTION_NS, "locations", "ex:locations");
                handler.endElement(EXCEPTION_NS, "exception", "ex:exception");
            }
            current = ExceptionUtils.getCause((Throwable)current);
        }
        handler.endElement(EXCEPTION_NS, "cocoon-stacktrace", "ex:cocoon-stacktrace");
        attr.clear();
        ExceptionGenerator.simpleElement("stacktrace", attr, ExceptionUtils.getStackTrace((Throwable)root), handler);
        if (thr != root) {
            String trace = SystemUtils.isJavaVersionAtLeast((int)140) ? ExceptionUtils.getStackTrace((Throwable)thr) : ExceptionUtils.getFullStackTrace((Throwable)thr);
            ExceptionGenerator.simpleElement("full-stacktrace", attr, trace, handler);
        }
        handler.endElement(EXCEPTION_NS, "exception-report", "ex:exception-report");
        handler.endPrefixMapping("ex");
    }

    private static void dumpLocation(Location loc, AttributesImpl attr, ContentHandler handler) throws SAXException {
        attr.addCDATAAttribute("uri", loc.getURI());
        attr.addCDATAAttribute("line", Integer.toString(loc.getLineNumber()));
        attr.addCDATAAttribute("column", Integer.toString(loc.getColumnNumber()));
        ExceptionGenerator.simpleElement("location", attr, loc.getDescription(), handler);
    }

    private static void simpleElement(String name, Attributes attr, String value, ContentHandler handler) throws SAXException {
        handler.startElement(EXCEPTION_NS, name, "ex:" + name, attr);
        if (value != null && value.length() > 0) {
            handler.characters(value.toCharArray(), 0, value.length());
        }
        handler.endElement(EXCEPTION_NS, name, "ex:" + name);
    }
}

