/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.ByteRange;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class ResourceReader
extends AbstractReader
implements CacheableProcessingComponent,
Configurable {
    private static final Map documents = Collections.synchronizedMap(new HashMap());
    protected long configuredExpires;
    protected boolean configuredQuickTest;
    protected int configuredBufferSize;
    protected boolean configuredByteRanges;
    protected long expires;
    protected boolean quickTest;
    protected int bufferSize;
    protected boolean byteRanges;
    protected Response response;
    protected Request request;
    protected Source inputSource;

    public void configure(Configuration configuration) throws ConfigurationException {
        Parameters parameters = Parameters.fromConfiguration((Configuration)configuration);
        this.configuredExpires = parameters.getParameterAsLong("expires", -1L);
        this.configuredQuickTest = parameters.getParameterAsBoolean("quick-modified-test", false);
        this.configuredBufferSize = parameters.getParameterAsInteger("buffer-size", 8192);
        this.configuredByteRanges = parameters.getParameterAsBoolean("byte-ranges", true);
        this.configuredExpires = configuration.getChild("expires").getValueAsLong(this.configuredExpires);
        this.configuredQuickTest = configuration.getChild("quick-modified-test").getValueAsBoolean(this.configuredQuickTest);
        this.configuredBufferSize = configuration.getChild("buffer-size").getValueAsInteger(this.configuredBufferSize);
        this.configuredByteRanges = configuration.getChild("byte-ranges").getValueAsBoolean(this.configuredByteRanges);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
    }

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.request = ObjectModelHelper.getRequest(objectModel);
        this.response = ObjectModelHelper.getResponse(objectModel);
        this.expires = par.getParameterAsLong("expires", this.configuredExpires);
        this.quickTest = par.getParameterAsBoolean("quick-modified-test", this.configuredQuickTest);
        this.bufferSize = par.getParameterAsInteger("buffer-size", this.configuredBufferSize);
        this.byteRanges = par.getParameterAsBoolean("byte-ranges", this.configuredByteRanges);
        try {
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException e) {
            throw SourceUtil.handle("Error during resolving of '" + src + "'.", e);
        }
        this.setupHeaders();
    }

    protected void setupHeaders() {
        if (this.byteRanges) {
            this.response.setHeader("Accept-Ranges", "bytes");
        } else {
            this.response.setHeader("Accept-Ranges", "none");
        }
        if (this.expires > 0L) {
            this.response.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
        } else if (this.expires == 0L) {
            this.response.setDateHeader("Expires", 0L);
        }
    }

    @Override
    public void recycle() {
        this.request = null;
        this.response = null;
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        super.recycle();
    }

    protected boolean hasRanges() {
        return this.byteRanges && this.request.getHeader("Range") != null;
    }

    @Override
    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    @Override
    public SourceValidity getValidity() {
        if (this.hasRanges()) {
            return null;
        }
        return this.inputSource.getValidity();
    }

    @Override
    public long getLastModified() {
        if (this.hasRanges()) {
            return 0L;
        }
        if (this.quickTest) {
            return this.inputSource.getLastModified();
        }
        String systemId = (String)documents.get(this.request.getRequestURI());
        if (systemId == null || this.inputSource.getURI().equals(systemId)) {
            return this.inputSource.getLastModified();
        }
        documents.remove(this.request.getRequestURI());
        return 0L;
    }

    protected void processStream(InputStream inputStream) throws IOException, ProcessingException {
        ByteRange byteRange;
        byte[] buffer = new byte[this.bufferSize];
        int length = -1;
        String ranges = this.request.getHeader("Range");
        if (this.byteRanges && ranges != null) {
            try {
                ranges = ranges.substring(ranges.indexOf(61) + 1);
                byteRange = new ByteRange(ranges);
            }
            catch (NumberFormatException e) {
                byteRange = null;
                if (this.response instanceof HttpResponse) {
                    ((HttpResponse)this.response).setStatus(416);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("malformed byte range header [" + String.valueOf(ranges) + "]");
                    }
                }
            }
        } else {
            byteRange = null;
        }
        long contentLength = this.inputSource.getContentLength();
        if (byteRange != null) {
            String entityRange;
            String entityLength;
            ByteRange actualByteRange = byteRange;
            if (contentLength != -1L) {
                entityLength = "" + contentLength;
                actualByteRange = byteRange.intersection(new ByteRange(0L, contentLength - 1L));
                entityRange = actualByteRange.toString();
            } else {
                entityLength = "*";
                entityRange = byteRange.toString();
            }
            this.response.setHeader("Content-Range", "bytes " + entityRange + "/" + entityLength);
            if (actualByteRange.length() != -1L) {
                this.response.setHeader("Content-Length", String.valueOf(actualByteRange.length()));
            }
            if (this.response instanceof HttpResponse) {
                ((HttpResponse)this.response).setStatus(206);
            }
            int pos = 0;
            while ((length = inputStream.read(buffer)) > -1) {
                int posEnd = pos + length - 1;
                ByteRange intersection = byteRange.intersection(new ByteRange(pos, posEnd));
                if (intersection != null) {
                    this.out.write(buffer, (int)intersection.getStart() - pos, (int)intersection.length());
                }
                pos += length;
            }
        } else {
            if (contentLength != -1L) {
                this.response.setHeader("Content-Length", Long.toString(contentLength));
            }
            while ((length = inputStream.read(buffer)) > -1) {
                this.out.write(buffer, 0, length);
            }
        }
        this.out.flush();
    }

    @Override
    public void generate() throws IOException, ProcessingException {
        try {
            InputStream inputStream;
            try {
                inputStream = this.inputSource.getInputStream();
            }
            catch (SourceException e) {
                throw SourceUtil.handle("Error during resolving of the input stream", e);
            }
            try {
                this.processStream(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (!this.quickTest) {
                documents.put(this.request.getRequestURI(), this.inputSource.getURI());
            }
        }
        catch (IOException e) {
            this.getLogger().debug("Received an IOException, assuming client severed connection on purpose");
            throw e;
        }
    }

    @Override
    public String getMimeType() {
        String mimeType;
        Context ctx = ObjectModelHelper.getContext(this.objectModel);
        if (ctx != null && (mimeType = ctx.getMimeType(this.source)) != null) {
            return mimeType;
        }
        return this.inputSource.getMimeType();
    }
}

