/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.selection.Selector;

public abstract class NamedPatternsSelector
extends AbstractLogEnabled
implements Configurable,
ThreadSafe,
Selector {
    private Map strings;

    protected void configure(Configuration conf, String confName, String nameAttr, String valueAttr) throws ConfigurationException {
        Configuration[] confs = conf.getChildren(confName);
        HashMap<String, ArrayList<String>> configMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < confs.length; ++i) {
            String string = confs[i].getAttribute(nameAttr);
            String value = confs[i].getAttribute(valueAttr);
            ArrayList<String> nameList = (ArrayList<String>)configMap.get(string);
            if (nameList == null) {
                nameList = new ArrayList<String>();
                configMap.put(string, nameList);
            }
            nameList.add(value);
        }
        for (Map.Entry entry : configMap.entrySet()) {
            List nameList = (List)entry.getValue();
            entry.setValue(nameList.toArray(new String[nameList.size()]));
        }
        this.strings = configMap;
    }

    protected boolean checkPatterns(String expression, String value) {
        return this.checkPatterns(expression, value, true);
    }

    protected boolean checkPatterns(String expression, String value, boolean caseSensitive) {
        if (value == null) {
            this.getLogger().debug("No value given -- failing.");
            return false;
        }
        String[] patterns = (String[])this.strings.get(expression);
        if (patterns == null) {
            this.getLogger().warn("No configuration for expression '" + expression + "' -- failing.");
            return false;
        }
        if (!caseSensitive) {
            value = value.toLowerCase();
        }
        for (int i = 0; i < patterns.length; ++i) {
            if ((!caseSensitive || value.indexOf(patterns[i]) == -1) && (caseSensitive || value.indexOf(patterns[i].toLowerCase()) == -1)) continue;
            this.getLogger().debug(expression + " selected value " + value);
            return true;
        }
        return false;
    }
}

