/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.cocoon.servlet.multipart.Part;

public class PartOnDisk
extends Part {
    private File file = null;
    private int size;

    public PartOnDisk(Map headers, File file) {
        super(headers);
        this.file = file;
        this.file.deleteOnExit();
        this.size = (int)file.length();
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        throw new IllegalStateException("This part has already been disposed.");
    }

    public String toString() {
        return this.file.getPath();
    }

    @Override
    public void dispose() {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

