/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FilterTransformer
extends AbstractTransformer
implements CacheableProcessingComponent {
    private static final String ELEMENT = "element-name";
    private static final String COUNT = "count";
    private static final String BLOCKNR = "blocknr";
    private static final String BLOCK = "block";
    private static final String BLOCKID = "id";
    private static final int DEFAULT_COUNT = 10;
    private static final int DEFAULT_BLOCK = 1;
    protected int counter;
    protected int count;
    protected int blocknr;
    protected int currentBlocknr;
    protected String elementName;
    protected String parentName;
    protected boolean skip;
    protected boolean foundIt;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.counter = 0;
        this.currentBlocknr = 0;
        this.skip = false;
        this.foundIt = false;
        this.parentName = null;
        this.elementName = parameters.getParameter(ELEMENT, "");
        this.count = parameters.getParameterAsInteger(COUNT, 10);
        this.blocknr = parameters.getParameterAsInteger(BLOCKNR, 1);
        if (this.elementName == null || this.elementName.length() == 0 || this.count == 0) {
            throw new ProcessingException("FilterTransformer: both element-name and count parameters need to be specified");
        }
    }

    @Override
    public Serializable getKey() {
        return this.elementName + '<' + this.count + '>' + this.blocknr;
    }

    @Override
    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    @Override
    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        if (name.equalsIgnoreCase(this.elementName)) {
            this.foundIt = true;
            ++this.counter;
            this.skip = this.counter > this.count * this.blocknr || this.counter <= this.count * (this.blocknr - 1);
            if (this.currentBlocknr != (int)Math.ceil((float)this.counter / (float)this.count)) {
                this.currentBlocknr = (int)Math.ceil((float)this.counter / (float)this.count);
                AttributesImpl attr = new AttributesImpl();
                attr.addAttribute("", BLOCKID, BLOCKID, "CDATA", String.valueOf(this.currentBlocknr));
                if (this.counter < this.count) {
                    this.contentHandler.startElement("", BLOCK, BLOCK, attr);
                } else {
                    if (this.counter > 1) {
                        this.contentHandler.endElement("", BLOCK, BLOCK);
                    }
                    this.contentHandler.startElement("", BLOCK, BLOCK, attr);
                }
            }
        } else if (!this.foundIt) {
            this.parentName = name;
        }
        if (!this.skip) {
            this.contentHandler.startElement(uri, name, raw, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.foundIt && name.equals(this.parentName)) {
            this.contentHandler.endElement("", BLOCK, BLOCK);
            this.contentHandler.endElement(uri, name, raw);
            this.foundIt = false;
            this.skip = false;
        } else if (!this.skip) {
            this.contentHandler.endElement(uri, name, raw);
        }
    }

    @Override
    public void characters(char[] c, int start, int len) throws SAXException {
        if (!this.skip) {
            this.contentHandler.characters(c, start, len);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.skip) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (!this.skip) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.skip) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (!this.skip) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (!this.skip) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int len) throws SAXException {
        if (!this.skip) {
            this.lexicalHandler.comment(ch, start, len);
        }
    }
}

