/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    private byte[] buffer;
    private int count;
    private int totalCount;
    private final int flushBufferSize;

    public BufferedOutputStream(OutputStream out) {
        this(out, 32768);
    }

    public BufferedOutputStream(OutputStream out, int flushBufferSize) {
        this(out, flushBufferSize, 8192);
    }

    public BufferedOutputStream(OutputStream out, int flushBufferSize, int initialBufferSize) {
        super(out);
        if (flushBufferSize <= 0 && flushBufferSize != -1) {
            throw new IllegalArgumentException("Flush buffer size <= 0 && != -1");
        }
        if (initialBufferSize <= 0) {
            throw new IllegalArgumentException("Initial buffer size <= 0");
        }
        int actualInitialBufferSize = flushBufferSize > 0 && initialBufferSize > flushBufferSize ? flushBufferSize : initialBufferSize;
        this.buffer = new byte[actualInitialBufferSize];
        this.flushBufferSize = flushBufferSize;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count == this.buffer.length) {
            this.increaseBuffer(1);
        }
        this.buffer[this.count++] = (byte)b;
        ++this.totalCount;
        this.checkForFlush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int actualIncrease;
        int free = this.buffer.length - this.count;
        int necessaryIncrease = len - free;
        if (necessaryIncrease > 0 && (actualIncrease = this.increaseBuffer(necessaryIncrease)) < necessaryIncrease) {
            this.writeToBuffer(b, off, free += actualIncrease);
            int newOff = off + free;
            for (int newLen = len - free; newLen > 0; newLen -= this.flushBufferSize) {
                this.writeToBuffer(b, newOff, Math.min(newLen, this.flushBufferSize));
                newOff += this.flushBufferSize;
            }
            return;
        }
        this.writeToBuffer(b, off, len);
    }

    private void writeToBuffer(byte[] b, int off, int len) throws IOException {
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
        this.totalCount += len;
        this.checkForFlush();
    }

    private void checkForFlush() throws IOException {
        if (this.count == this.flushBufferSize) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    private int increaseBuffer(int increase) {
        int actualIncrease;
        int oldLength = this.buffer.length;
        if (oldLength == this.flushBufferSize) {
            return 0;
        }
        int newLength = oldLength;
        do {
            if (this.flushBufferSize <= 0 || (newLength *= 2) < this.flushBufferSize) continue;
            newLength = this.flushBufferSize;
            actualIncrease = newLength - oldLength;
            break;
        } while ((actualIncrease = newLength - oldLength) < increase);
        byte[] newBuffer = new byte[newLength];
        if (this.count > 0) {
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.count);
        }
        this.buffer = newBuffer;
        return actualIncrease;
    }

    public void clearBuffer() {
        this.totalCount -= this.count;
        this.count = 0;
    }

    public void reset() {
        this.clearBuffer();
    }

    public boolean isResettable() {
        return this.count == this.totalCount;
    }

    public int getCount() {
        return this.totalCount;
    }
}

