/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

public final class ByteRange {
    private final long start;
    private final long end;

    public ByteRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public ByteRange(String string) throws NumberFormatException {
        string = string.trim();
        int dashPos = string.indexOf(45);
        int length = string.length();
        if (string.indexOf(44) != -1) {
            throw new NumberFormatException("Simple ByteRange String contains a comma.");
        }
        this.start = dashPos > 0 ? (long)Integer.parseInt(string.substring(0, dashPos)) : Long.MIN_VALUE;
        this.end = dashPos < length - 1 ? (long)Integer.parseInt(string.substring(dashPos + 1, length)) : Long.MAX_VALUE;
        if (this.start > this.end) {
            throw new NumberFormatException("Start value is greater than end value.");
        }
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long length() {
        if (this.start == Long.MIN_VALUE || this.end == Long.MAX_VALUE) {
            return -1L;
        }
        return this.end - this.start + 1L;
    }

    public ByteRange intersection(ByteRange range) {
        if (range.end < this.start || this.end < range.start) {
            return null;
        }
        long start = this.start > range.start ? this.start : range.start;
        long end = this.end < range.end ? this.end : range.end;
        return new ByteRange(start, end);
    }

    public String toString() {
        return this.start + "-" + this.end;
    }
}

