/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.util.Settings;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public class PropertySettings
implements Settings {
    private Map properties = new HashMap();
    protected static final Map CONTEXT_PARAMETERS = Collections.singletonMap("force-traversable", Boolean.TRUE);

    public PropertySettings(SourceResolver resolver, Logger logger) {
        File testFile;
        String additionalPropertyFile;
        this.readProperties("context://WEB-INF/properties", resolver);
        String string = additionalPropertyFile = this.properties.containsKey("org.apache.cocoon.settings") ? (String)this.properties.get("org.apache.cocoon.settings") : System.getProperty("org.apache.cocoon.settings");
        if (additionalPropertyFile == null && !(testFile = new File(additionalPropertyFile = System.getProperty("user.home") + File.separator + ".cocoon/settings.properties")).exists()) {
            additionalPropertyFile = null;
        }
        if (additionalPropertyFile != null) {
            logger.debug("Reading user settings from '" + additionalPropertyFile + "'");
            Properties p = new Properties();
            try {
                FileInputStream fis = new FileInputStream(additionalPropertyFile);
                p.load(fis);
                fis.close();
            }
            catch (IOException ignore) {
                logger.warn("Unable to read '" + additionalPropertyFile + "'.", (Throwable)ignore);
                logger.warn("Continuing initialization.");
            }
            this.properties.putAll(p);
        }
        this.properties.putAll(System.getProperties());
        if (logger.isDebugEnabled()) {
            Iterator iter = this.properties.keySet().iterator();
            logger.debug("Cocoon Properties:");
            while (iter.hasNext()) {
                String key = (String)iter.next();
                logger.debug("Key: " + key + " Value: " + this.properties.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readProperties(String directoryName, SourceResolver resolver) {
        Source directory;
        block5: {
            directory = null;
            try {
                directory = resolver.resolveURI(directoryName, null, CONTEXT_PARAMETERS);
                if (!directory.exists() || !(directory instanceof TraversableSource)) break block5;
                for (Source src : ((TraversableSource)directory).getChildren()) {
                    if (!src.getURI().endsWith(".properties")) continue;
                    Properties props = new Properties();
                    InputStream propsIS = src.getInputStream();
                    props.load(propsIS);
                    propsIS.close();
                    this.properties.putAll(props);
                }
            }
            catch (IOException ignore) {
                resolver.release(directory);
                catch (Throwable throwable) {
                    resolver.release(directory);
                    throw throwable;
                }
            }
        }
        resolver.release(directory);
    }

    @Override
    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = (String)this.properties.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public List getProperties(String keyPrefix) {
        ArrayList<String> props = new ArrayList<String>();
        for (String name : this.properties.keySet()) {
            if (!name.startsWith(keyPrefix) || props.contains(name)) continue;
            props.add(name);
        }
        return props;
    }

    @Override
    public List getProperties() {
        ArrayList props = new ArrayList();
        props.addAll(this.properties.keySet());
        return props;
    }

    @Override
    public int size() {
        return this.properties.size();
    }
}

