/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.type;

import io.bit3.jsass.type.SassBoolean;
import io.bit3.jsass.type.SassError;
import io.bit3.jsass.type.SassList;
import io.bit3.jsass.type.SassMap;
import io.bit3.jsass.type.SassNull;
import io.bit3.jsass.type.SassNumber;
import io.bit3.jsass.type.SassString;
import io.bit3.jsass.type.SassValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static SassValue convertToSassValue(Object value) {
        if (null == value) {
            return SassNull.SINGLETON;
        }
        if (value instanceof SassValue) {
            return (SassValue)value;
        }
        Class<?> cls = value.getClass();
        if (TypeUtils.isaBoolean(cls)) {
            return new SassBoolean((Boolean)value);
        }
        if (TypeUtils.isaNumber(cls)) {
            return new SassNumber(((Number)value).doubleValue(), "");
        }
        if (TypeUtils.isaString(cls) || TypeUtils.isaCharacter(cls)) {
            return new SassString(value.toString());
        }
        if (value instanceof Collection) {
            return new SassList((Collection<?>)((Collection)value).stream().map(TypeUtils::convertToSassValue).collect(Collectors.toList()));
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> TypeUtils.convertToSassValue(entry.getValue()), (origin, duplicate) -> origin, SassMap::new));
        }
        if (value instanceof Throwable) {
            Throwable throwable = (Throwable)value;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            String message = throwable.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                printWriter.append(message).append(System.lineSeparator());
            }
            throwable.printStackTrace(printWriter);
            return new SassError(stringWriter.toString());
        }
        return new SassError(String.format("Could not convert object of type %s into a sass value", value.getClass().toString()));
    }

    private static boolean isaNumber(Class cls) {
        return Number.class.isAssignableFrom(cls) || Byte.TYPE.isAssignableFrom(cls) || Short.TYPE.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls) || Long.TYPE.isAssignableFrom(cls) || Float.TYPE.isAssignableFrom(cls) || Double.TYPE.isAssignableFrom(cls);
    }

    public static boolean isaString(Class<?> type) {
        return CharSequence.class.isAssignableFrom(type);
    }

    public static boolean isaByte(Class<?> type) {
        return Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type);
    }

    public static boolean isaShort(Class<?> type) {
        return Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type);
    }

    public static boolean isaInteger(Class<?> type) {
        return Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type);
    }

    public static boolean isaLong(Class<?> type) {
        return Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type);
    }

    public static boolean isaFloat(Class<?> type) {
        return Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type);
    }

    public static boolean isaDouble(Class<?> type) {
        return Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
    }

    public static boolean isaCharacter(Class<?> type) {
        return Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type);
    }

    public static boolean isaBoolean(Class<?> type) {
        return Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type);
    }
}

