/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.Errors;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ActionResultGenerator
extends AbstractGenerator {
    public static final String MAP_REQUEST_ATTR = ActionResultGenerator.class.getName() + ";map";

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"ActionResult");
        this.saxParams();
        this.saxMap();
        this.saxSource();
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"ActionResult");
        this.contentHandler.endDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saxSource() throws IOException, SAXException, ProcessingException {
        if (StringUtils.isEmpty((String)this.source)) {
            return;
        }
        SitemapSource sitemapSource = null;
        try {
            HashMap<String, String> jsParameters = new HashMap<String, String>();
            int argsIndex = this.source.indexOf(63);
            if (argsIndex >= 0) {
                String[] argsArrayString;
                String argsString = this.source.substring(argsIndex + 1);
                for (String argString : argsArrayString = argsString.split("&")) {
                    if (StringUtils.isEmpty((String)argString)) continue;
                    String argsName = argString;
                    String argsValue = "";
                    int equalsIndex = argString.indexOf("=");
                    if (equalsIndex >= 0) {
                        argsName = argString.substring(0, equalsIndex);
                        argsValue = argString.substring(equalsIndex + 1);
                    }
                    jsParameters.put(argsName, argsValue);
                }
            }
            sitemapSource = (SitemapSource)this.resolver.resolveURI("cocoon:/" + this.source, null, jsParameters);
            sitemapSource.toSAX((ContentHandler)((Object)new IgnoreRootHandler(this.contentHandler)));
        }
        catch (Throwable throwable) {
            this.resolver.release(sitemapSource);
            throw throwable;
        }
        this.resolver.release((Source)sitemapSource);
    }

    protected void saxParams() throws IOException, SAXException, ProcessingException {
        for (String parameterName : this.parameters.getNames()) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)parameterName, (String)this.parameters.getParameter(parameterName, ""));
        }
    }

    protected void saxMapItem(String key, Object value) throws IOException, SAXException, ProcessingException {
        if (value instanceof Errors) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)key);
            for (I18nizableText errorLabel : ((Errors)value).getErrors()) {
                errorLabel.toSAX(this.contentHandler, "error");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)key);
        } else if (value instanceof I18nizableText) {
            ((I18nizableText)value).toSAX(this.contentHandler, key);
        } else if (value instanceof Collection) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)key);
            for (Object item : (Collection)value) {
                if (item == null) continue;
                this.saxMapItem(key, item);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)key);
        } else if (value instanceof Map) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)key);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String iKey = (String)entry.getKey();
                Object iValue = entry.getValue();
                this.saxMapItem(iKey, iValue);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)key);
        } else if (value instanceof Object[]) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)key);
            for (Object item : (Object[])value) {
                if (item == null) continue;
                this.saxMapItem(key, item);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)key);
        } else {
            String stringValue = "";
            if (value != null) {
                stringValue = value.toString();
            }
            stringValue = stringValue.replace('\u0000', ' ');
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)key, (String)stringValue);
        }
    }

    protected void saxMap() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Map map = (Map)request.getAttribute(MAP_REQUEST_ATTR);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.saxMapItem(key, value);
            }
        }
    }
}

