/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon.source;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;

public class ProxySourceFactory
extends AbstractLogEnabled
implements SourceFactory,
ThreadSafe,
Serviceable,
Configurable {
    protected Pattern _matcher;
    protected List<String> _protocols;
    private SourceResolver _sourceResolver;
    private ServiceManager _manager;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._matcher = Pattern.compile(configuration.getChild("match").getValue());
        this._protocols = new ArrayList<String>();
        for (Configuration protocolConf : configuration.getChild("protocols").getChildren("protocol")) {
            String protocol = protocolConf.getValue();
            if (!StringUtils.isBlank((String)protocol)) {
                this._protocols.add(protocol);
                continue;
            }
            this.getLogger().warn("Trying to configure a blank protocol. Ignoring this line.");
        }
        if (this._protocols.size() == 0) {
            throw new ConfigurationException("Cannot configure this protocol with no redirecting protocols. Add <protocol>...</protocol> items in this component configuration.", configuration);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException {
        Matcher matcher;
        if (this._sourceResolver == null) {
            try {
                this._sourceResolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
            }
            catch (ServiceException e) {
                throw new IOException(e);
            }
        }
        if (!(matcher = this._matcher.matcher(location)).matches()) {
            throw new MalformedURLException("Invalid format for source : " + location);
        }
        Source source = null;
        Iterator<String> iterator = this._protocols.iterator();
        while (iterator.hasNext()) {
            String protocol;
            String uri = protocol = iterator.next();
            try {
                for (int groupIndex = 0; groupIndex <= matcher.groupCount(); ++groupIndex) {
                    uri = uri.replaceAll("\\{" + groupIndex + "\\}", matcher.group(groupIndex));
                }
                source = this._sourceResolver.resolveURI(uri, null, parameters);
                if (!source.exists()) {
                    this._sourceResolver.release(source);
                    source = null;
                    continue;
                }
                return source;
            }
            catch (IOException iOException) {
            }
        }
        throw new SourceNotFoundException("Source not found '" + location + "'. (tried successively in " + this._protocols + ")");
    }

    public void release(Source source) {
    }
}

