/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon.source;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.impl.AbstractSource;

public class ZipSource
extends AbstractSource {
    private ZipFile _zipFile;
    private ZipEntry _zipEntry;

    public ZipSource(String location) {
        int index = location.indexOf("://");
        if (index == -1) {
            throw new IllegalArgumentException("A ZipSource URI must be like zip://path/to/file!path/to/entry");
        }
        this.setScheme(location.substring(0, index));
        this.setSystemId(location.substring(index + 3));
        int fileIndex = location.indexOf(33);
        if (fileIndex < index) {
            throw new IllegalArgumentException("A ZipSource URI must be like zip://path/to/file!path/to/entry");
        }
        String file = location.substring(index + 1, fileIndex);
        try {
            this._zipFile = new ZipFile(file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to open zip file", e);
        }
        String entry = location.substring(fileIndex + 1);
        this._zipEntry = this._zipFile.getEntry(entry);
    }

    public boolean exists() {
        return this._zipFile != null && this._zipEntry != null;
    }

    public InputStream getInputStream() throws IOException {
        if (this._zipFile == null || this._zipEntry == null) {
            throw new SourceNotFoundException("ZipSource not available");
        }
        return this._zipFile.getInputStream(this._zipEntry);
    }

    public void close() {
        this._zipEntry = null;
        try {
            this._zipFile.close();
            this._zipFile = null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to close zip file");
        }
    }
}

