/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.UnknownDataSourceException;
import org.ametys.core.datasource.dbtype.SQLDatabaseType;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.plugins.core.impl.checker.SQLConnectionChecker;
import org.ametys.plugins.core.impl.datasource.DerbySQLDatabaseType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.xml.sax.SAXException;

public class SQLDataSourceManager
extends AbstractDataSourceManager {
    public static final String ROLE = SQLDataSourceManager.class.getName();
    public static final String PARAM_DATABASE_TYPE = "dbtype";
    public static final String PARAM_DATABASE_URL = "url";
    public static final String PARAM_DATABASE_USER = "user";
    public static final String PARAM_DATABASE_PASSWORD = "password";
    public static final String SQL_DATASOURCE_PREFIX = "SQL-";
    public static final String AMETYS_INTERNAL_DATASOURCE_ID = "SQL-ametys-internal";
    private static final I18nizableText __AMETYS_INTERNAL_DATASOURCE_NAME = new I18nizableText("plugin.core", "PLUGINS_CORE_INTERNAL_DATASOURCE_LABEL");
    private static final I18nizableText __AMETYS_INTERNAL_DATASOURCE_DESCRIPTION = new I18nizableText("plugin.core", "PLUGINS_CORE_INTERNAL_DATASOURCE_DESCRIPTION");
    private static String __filename;
    private Map<String, DataSource> _sqlDataSources;
    private Map<String, ObjectPool> _pools;
    private AbstractDataSourceManager.DataSourceDefinition _internalDataSource;
    private SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeEP;
    private ServiceManager _manager;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        this._manager = serviceManager;
        super.service(serviceManager);
    }

    public static Map<String, AbstractDataSourceManager.DataSourceDefinition> readDataSourceDefinition(File file) {
        HashMap<String, AbstractDataSourceManager.DataSourceDefinition> definitions = new HashMap<String, AbstractDataSourceManager.DataSourceDefinition>();
        try {
            if (file.exists()) {
                Configuration configuration = new DefaultConfigurationBuilder().buildFromFile(file);
                for (Configuration dsConfig : configuration.getChildren("datasource")) {
                    Configuration[] paramsConfig;
                    String id = dsConfig.getAttribute("id");
                    I18nizableText name = I18nizableText.parseI18nizableText(dsConfig.getChild("name"), "plugin.core");
                    I18nizableText description = I18nizableText.parseI18nizableText(dsConfig.getChild("description"), "plugin.core", "");
                    boolean isPrivate = dsConfig.getAttributeAsBoolean("private", false);
                    boolean isDefault = dsConfig.getAttributeAsBoolean("default", false);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    for (Configuration paramConfig : paramsConfig = dsConfig.getChild("parameters").getChildren()) {
                        String value = paramConfig.getValue("");
                        parameters.put(paramConfig.getName(), value);
                    }
                    AbstractDataSourceManager.DataSourceDefinition dataSource = new AbstractDataSourceManager.DataSourceDefinition(id, name, description, parameters, isPrivate, isDefault);
                    definitions.put(id, dataSource);
                }
            }
            return definitions;
        }
        catch (IOException | ConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to parse datasource configuration file.", e);
        }
    }

    @Override
    protected Map<String, AbstractDataSourceManager.DataSourceDefinition> doReadConfiguration(File file) {
        return SQLDataSourceManager.readDataSourceDefinition(file);
    }

    private SQLDatabaseTypeExtensionPoint getSQLDatabaseTypeEP() {
        if (this._sqlDatabaseTypeEP == null) {
            try {
                this._sqlDatabaseTypeEP = (SQLDatabaseTypeExtensionPoint)this._manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._sqlDatabaseTypeEP;
    }

    public static void setFilename(String filename) {
        __filename = filename;
    }

    public static File getStaticFileConfiguration() {
        if (__filename != null) {
            return new File(__filename);
        }
        return new File(AmetysHomeHelper.getAmetysHomeConfig(), "datasources-sql.xml");
    }

    @Override
    public File getFileConfiguration() {
        return SQLDataSourceManager.getStaticFileConfiguration();
    }

    @Override
    public void initialize() throws Exception {
        this._sqlDataSources = new HashMap<String, DataSource>();
        this._pools = new HashMap<String, ObjectPool>();
        this._internalDataSource = SQLDataSourceManager.getInternalDataSourceDefinition();
        super.initialize();
        this.createDataSource(this._internalDataSource);
    }

    @Override
    public AbstractDataSourceManager.DataSourceDefinition getDataSourceDefinition(String id) {
        this.readConfiguration();
        if (AMETYS_INTERNAL_DATASOURCE_ID.equals(id)) {
            return this._internalDataSource;
        }
        return super.getDataSourceDefinition(id);
    }

    @Override
    public Map<String, AbstractDataSourceManager.DataSourceDefinition> getDataSourceDefinitions(boolean includePrivate, boolean includeInternal, boolean includeDefault) {
        this.readConfiguration();
        LinkedHashMap<String, AbstractDataSourceManager.DataSourceDefinition> datasources = new LinkedHashMap<String, AbstractDataSourceManager.DataSourceDefinition>();
        if (includePrivate && includeInternal) {
            datasources.put(AMETYS_INTERNAL_DATASOURCE_ID, this._internalDataSource);
        }
        datasources.putAll(super.getDataSourceDefinitions(includePrivate, includeInternal, includeDefault));
        return datasources;
    }

    @Override
    protected String getDataSourcePrefixId() {
        return SQL_DATASOURCE_PREFIX;
    }

    public static AbstractDataSourceManager.DataSourceDefinition getInternalDataSourceDefinition() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAM_DATABASE_TYPE, "derby");
        File dbFile = new File(RuntimeConfig.getInstance().getAmetysHome(), "data" + File.separator + "internal-db");
        parameters.put(PARAM_DATABASE_URL, "jdbc:derby:" + dbFile.getAbsolutePath() + ";create=true");
        parameters.put(PARAM_DATABASE_USER, "");
        parameters.put(PARAM_DATABASE_PASSWORD, "");
        return new AbstractDataSourceManager.DataSourceDefinition(AMETYS_INTERNAL_DATASOURCE_ID, __AMETYS_INTERNAL_DATASOURCE_NAME, __AMETYS_INTERNAL_DATASOURCE_DESCRIPTION, parameters, true, false);
    }

    public Connection getInternalSQLDataSourceConnection() {
        Connection connection = null;
        try {
            DataSource dataSource = this.getSQLDataSource(AMETYS_INTERNAL_DATASOURCE_ID);
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to get the connection to the internal ametys SQL data source", e);
        }
        return connection;
    }

    public Map<String, DataSource> getSQLDataSources() {
        return this._sqlDataSources;
    }

    public DataSource getSQLDataSource(String id) {
        DataSource dataSource = this._sqlDataSources.get(id);
        if (this.getDefaultDataSourceId().equals(id)) {
            String actualDataSourceId = this.getDefaultDataSourceDefinition().getId();
            dataSource = this._sqlDataSources.get(actualDataSourceId);
        }
        if (dataSource == null) {
            throw new UnknownDataSourceException("The data source of id '" + id + "' was not found.");
        }
        return dataSource;
    }

    @Override
    public AbstractDataSourceManager.DataSourceDefinition setDefaultDataSource(String id) {
        this.readConfiguration();
        AbstractDataSourceManager.DataSourceDefinition oldDefaultDataSource = this.getDefaultDataSourceDefinition();
        if (oldDefaultDataSource != null && oldDefaultDataSource.getId().equals(AMETYS_INTERNAL_DATASOURCE_ID)) {
            this._internalDataSource.setDefault(false);
        }
        try {
            return super.setDefaultDataSource(id);
        }
        catch (RuntimeException e) {
            if (id.equals(AMETYS_INTERNAL_DATASOURCE_ID)) {
                this._internalDataSource.setDefault(true);
                return this._internalDataSource;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public AbstractDataSourceManager.DataSourceDefinition getDefaultDataSourceDefinition() {
        if (this._internalDataSource.isDefault()) {
            return this._internalDataSource;
        }
        return super.getDefaultDataSourceDefinition();
    }

    @Override
    protected void internalSetDefaultDataSource() {
        this._internalDataSource.setDefault(true);
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) throws ItemCheckerTestFailureException {
        SQLConnectionChecker.check((String)parameters.get(PARAM_DATABASE_URL), (String)parameters.get(PARAM_DATABASE_USER), (String)parameters.get(PARAM_DATABASE_PASSWORD), this._manager);
    }

    @Override
    protected void editDataSource(AbstractDataSourceManager.DataSourceDefinition dataSource) {
        this.deleteDataSource(dataSource);
        this.createDataSource(dataSource);
    }

    @Override
    protected void createDataSource(AbstractDataSourceManager.DataSourceDefinition dataSourceDef) {
        Map<String, Object> parameters = dataSourceDef.getParameters();
        String url = (String)parameters.get(PARAM_DATABASE_URL);
        String user = (String)parameters.get(PARAM_DATABASE_USER);
        String password = (String)parameters.get(PARAM_DATABASE_PASSWORD);
        String dbtype = (String)parameters.get(PARAM_DATABASE_TYPE);
        if (!this.getSQLDatabaseTypeEP().hasExtension(dbtype)) {
            throw new IllegalArgumentException("Database of type '" + dbtype + "' is not supported");
        }
        SQLDatabaseType sqlDbType = (SQLDatabaseType)this.getSQLDatabaseTypeEP().getExtension(dbtype);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, user, password);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        connectionPool.setMaxTotal(-1);
        connectionPool.setMaxIdle(10);
        connectionPool.setMinIdle(2);
        connectionPool.setTestOnBorrow(true);
        connectionPool.setTestOnReturn(false);
        connectionPool.setTestWhileIdle(true);
        connectionPool.setTimeBetweenEvictionRunsMillis(1800000L);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        poolableConnectionFactory.setValidationQuery(sqlDbType.getValidationQuery());
        poolableConnectionFactory.setDefaultAutoCommit(Boolean.valueOf(true));
        poolableConnectionFactory.setDefaultReadOnly(Boolean.valueOf(false));
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        String id = dataSourceDef.getId();
        if (this._pools.containsKey(id)) {
            this._disposePool(id);
        }
        this._pools.put(id, (ObjectPool)connectionPool);
        this._sqlDataSources.put(id, (DataSource)dataSource);
    }

    @Override
    protected void deleteDataSource(AbstractDataSourceManager.DataSourceDefinition dataSource) {
        this._sqlDataSources.remove(dataSource.getId());
        this._disposePool(dataSource.getId());
    }

    @Override
    public void dispose() {
        super.dispose();
        for (String id : this._pools.keySet()) {
            this._closePool(id);
        }
        this._pools = null;
        this._sqlDataSources = null;
    }

    private void _disposePool(String id) {
        this._closePool(id);
        this._pools.remove(id);
    }

    private void _closePool(String id) {
        try {
            this._pools.get(id).close();
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to close the connection pool '{}'", (Object)id, (Object)e);
        }
        try {
            AbstractDataSourceManager.DataSourceDefinition definition = this.getDataSourceDefinition(id);
            Map<String, Object> parameters = definition.getParameters();
            String dbtype = (String)parameters.get(PARAM_DATABASE_TYPE);
            if ("derby".equals(dbtype)) {
                DerbySQLDatabaseType.shutDown(definition);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to shutdown a Derby database '{}'", (Object)id, (Object)e);
        }
    }
}

