/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource.dbtype;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.datasource.dbtype.SQLDatabaseType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class SQLDatabaseTypeExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<SQLDatabaseType> {
    public static final String ROLE = SQLDatabaseTypeExtensionPoint.class.getName();

    @Override
    public void initializeExtensions() throws Exception {
        super.initializeExtensions();
        for (String databaseTypeId : this.getExtensionsIds()) {
            SQLDatabaseType databaseType = (SQLDatabaseType)this.getExtension(databaseTypeId);
            try {
                Class.forName(databaseType.getDriver());
            }
            catch (ClassNotFoundException e) {
                this.getLogger().warn("JDBC Driver cannot be found for extension '" + databaseTypeId + "' with classname '" + databaseType.getDriver() + "'");
            }
        }
    }

    public Map<String, I18nizableText> getSQLDatabaseTypes() {
        HashMap<String, I18nizableText> db = new HashMap<String, I18nizableText>();
        Set<String> extensionsIds = this.getExtensionsIds();
        for (String extensionId : extensionsIds) {
            SQLDatabaseType dbType = (SQLDatabaseType)this.getExtension(extensionId);
            db.put(extensionId, dbType.getLabel());
        }
        return db;
    }

    public String languageEscapeTableName(String dbType, String tableNameToEscape) {
        if (this.hasExtension(dbType)) {
            return ((SQLDatabaseType)this.getExtension(dbType)).languageEscapeTableName(tableNameToEscape);
        }
        return null;
    }

    public String languageLimitQuery(String dbType, String queryToLimit, String limit, String offset) {
        if (this.hasExtension(dbType)) {
            return ((SQLDatabaseType)this.getExtension(dbType)).languageLimitQuery(queryToLimit, limit, offset);
        }
        return null;
    }

    public InputStream getBlob(String dbType, ResultSet resultSet, String columnName) throws SQLException {
        if (this.hasExtension(dbType)) {
            return ((SQLDatabaseType)this.getExtension(dbType)).getBlob(resultSet, columnName);
        }
        return null;
    }

    public InputStream getBlob(String dbType, ResultSet resultSet, int pos) throws SQLException {
        if (this.hasExtension(dbType)) {
            return ((SQLDatabaseType)this.getExtension(dbType)).getBlob(resultSet, pos);
        }
        return null;
    }

    public void setBlob(String dbType, PreparedStatement statement, int pos, String blob) throws SQLException, UnsupportedEncodingException, IllegalArgumentException {
        if (!this.hasExtension(dbType)) {
            throw new IllegalArgumentException("Database of type '" + dbType + "' is not supported");
        }
        ((SQLDatabaseType)this.getExtension(dbType)).setBlob(statement, pos, blob);
    }

    public void setBlob(String dbType, PreparedStatement statement, int pos, byte[] bytes) throws SQLException, IllegalArgumentException {
        if (!this.hasExtension(dbType)) {
            throw new IllegalArgumentException("Database of type '" + dbType + "' is not supported");
        }
        ((SQLDatabaseType)this.getExtension(dbType)).setBlob(statement, pos, bytes);
    }

    public void setBlob(String dbType, PreparedStatement statement, int pos, InputStream is, long length) throws SQLException, IllegalArgumentException {
        if (!this.hasExtension(dbType)) {
            throw new IllegalArgumentException("Database of type '" + dbType + "' is not supported");
        }
        ((SQLDatabaseType)this.getExtension(dbType)).setBlob(statement, pos, is, length);
    }
}

