/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.ametys.core.model.type.AbstractElementType;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDateElementType
extends AbstractElementType<LocalDate> {
    public static final String TYPE_ID = "date";

    @Override
    public LocalDate castValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return LocalDate.parse(value, DateTimeFormatter.ISO_DATE_TIME);
    }

    @Override
    public String toString(LocalDate value) {
        if (value == null) {
            return null;
        }
        LocalDateTime ldt = value.atStartOfDay();
        return ldt.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @Override
    public Object valueToJSONForClient(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof LocalDate) {
            return this.toString((LocalDate)value);
        }
        if (value instanceof LocalDate[]) {
            ArrayList<String> values = new ArrayList<String>();
            for (LocalDate singleValue : (LocalDate[])value) {
                values.add(this.toString(singleValue));
            }
            return values;
        }
        throw new IllegalArgumentException("Try to convert the non Date value '" + value + "' to JSON");
    }

    @Override
    public Object fromJSONForClient(Object json) {
        if (json == null) {
            return json;
        }
        if (json instanceof String) {
            return this.castValue((String)json);
        }
        if (json instanceof List) {
            List jsonList = (List)json;
            ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
            for (String singleJSON : jsonList) {
                dateList.add(this.castValue(singleJSON));
            }
            return dateList.toArray(new LocalDate[dateList.size()]);
        }
        throw new IllegalArgumentException("Try to convert the non Date JSON object '" + json + "' into a Date");
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

